// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_syntax_tree__
#define __pre_syntax_tree__

// Syntax tree definition according to the composite pattern from [GoF].

#include "Puma/PreVisitor.h"
#include "Puma/Token.h"

namespace Puma {


// Common node interface
class PreTree {
protected:
  PreTree () {};

public:
  virtual void add_son (PreTree *);
  virtual void replace_son (int, PreTree *);
  virtual PreTree *son (int) const;
  virtual int sons () const;

  virtual void add_daughter (PreTree *);
  virtual void replace_daughter (int, PreTree *);
  virtual PreTree *daughter (int) const;
  virtual int daughters () const;

  virtual ~PreTree() {}
  virtual bool isLeaf () const;
  virtual void accept (PreVisitor &) = 0;
        
  virtual Token *startToken () const;
  virtual Token *endToken () const;
};

 
} // namespace Puma

#endif /* __pre_syntax_tree__ */
