// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/KeywordRecognizer.h"
#include "Puma/ScanBuffer.h"
#include <ctype.h>

namespace Puma {


int KeywordRecognizer::recognize (CScanBuffer *scan_buffer, int &expr, int &len) {
  int result = recognizer().recognize (scan_buffer, expr, len);

  // if it looks like a keyword we have to check if some character follows
  // that makes it an identifier instead of a keyword
  if (result == 1) {
    scan_buffer->more (len);
    if (scan_buffer->state () == ScanBuffer::STATE_OK) { 
      char next = scan_buffer->next ();
      if (isalnum ((int)next) || next == '_')
        result = 0;
      scan_buffer->more (len);
    }
  }
  return result;
}
         

} // namespace Puma
