// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/Filter.h"
#include <string.h>

namespace Puma {


Filter::Filter (const char *sig) : Signature (sig) {
  compiled = false;
  re_name = (RegComp*)0;
  re_type = (RegComp*)0;
}


Filter::~Filter() {
  clear ();
}


RegComp *Filter::new_re (const char *sig) {
  char *buffer = new char[3 + strlen (sig) * 2];
  char *p = buffer;
  char ch;

  *p++ = '^';
  while (*sig) {
    ch = *sig++;
    switch (ch) {
      case '%':
        *p++ = '.';
        *p++ = '*';
        break;
      case '*':
      case '.':
      case '(':
      case ')':
        *p++ = '\\';
      default:
        *p++ = ch;
    }
  }
  *p++ = '$';
  *p++ = 0;
    
  RegComp *reg = new RegComp (buffer);
  delete[] buffer;
  return reg;
}


void Filter::clear () {
  if (compiled) {
    delete re_name;
    delete re_type;
    for (unsigned i = 0; i < argc (); i++) 
      delete re_arg[i];
    compiled = false;
  }
}

    
void Filter::compile () {
  clear ();
  if (! compiled) {
    re_name = new_re (name ());
    re_type = new_re (type ());
    for (unsigned i = 0; i < argc (); i++) 
      re_arg[i] = new_re(argv(i));
    compiled = true;
  }
}


bool Filter::match (Signature &sig) {
  if (!compiled)
    compile ();
  if (method () != sig.method ()) 
    return false;
  if (! re_name->match (sig.name ())) 
    return false;
  if (! re_type->match (sig.type ())) 
    return false;
  for (unsigned i = 0; i < argc (); i++) {
    if (! strcmp (argv (i), "...") && (i + 1 == argc ())) {
      return true;
    }
    if (sig.argc () <= i) 
      return false;
    if (! re_arg[i]->match (sig.argv (i))) 
      return false;
  }
  // we cannot do this earlier because of "..."
  if (argc () != sig.argc ()) 
    return false;
  return true;
}


} // namespace Puma
