// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CLabelInfo_h__
#define __CLabelInfo_h__

// jump label info

#include "Puma/CScopeRequest.h"

namespace Puma {


/** \file 
 *  Representation of a C/C++ jump label.
 *  \see Puma::CLabelInfo */

/** \class CLabelInfo CLabelInfo.h Puma/infos/CLabelInfo.h
 *  A CLabelInfo object represents a C/C++ jump label. */
class CLabelInfo : public CScopeRequest {
public: 
  /** Construct a new jump label info. */
  CLabelInfo ();
  /** Destruct the jump label info. If the object id is 
   *  \c LABEL_INFO, Puma::CObjectInfo::CleanUp() is called. */
  ~CLabelInfo ();
};

inline CLabelInfo::CLabelInfo () :
  CScopeRequest (CObjectInfo::LABEL_INFO)
 {}


} // namespace Puma

#endif /* __CLabelInfo_h__ */
