// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Transformer_h__
#define __Transformer_h__

#include "CodeWeaver.h"

#include "Puma/CCParser.h"
#include "Puma/CCSemVisitor.h"
using namespace Puma;

namespace Puma {
  class VerboseMgr;
  class ErrorStream;
  class CProject;
  class CClassDatabase;
  class ACAspectInfo;
  class ACIntroductionInfo;
  class CTranslationUnit;
  class CT_AdviceDecl;
} // namespace Puma

class PointCut;
class Repository;
class Plan;
class PointCutContext;
class ACConfig;

class Transformer
 {
      VerboseMgr &_vm;
      ErrorStream &_err;
      CProject &_project;
      Repository &_repo;
      CodeWeaver _code_weaver;
      CCParser _parser;
      CCSemVisitor _sem_visitor;
      Token *_primary_start;
      Token *_primary_end;
      ACConfig &_conf;
      
      bool phase1 (Unit *unit, CTranslationUnit *&, PointCutContext *&, Plan &);
      bool phase2 (Unit *unit, CTranslationUnit *, PointCutContext&, Plan &);
      void aspect_priviledges (CTranslationUnit &tunit);
      void cleanup (CTranslationUnit &tunit);
      void orderings (CTranslationUnit &, Plan&, PointCutContext&, bool);
      void introductions (CTranslationUnit &, PointCutContext &, Plan &);
      void advice (CTranslationUnit &tunit);
      void singleton_aspects (CTranslationUnit &);
      void collect_ordering (CClassDatabase &db, ACAspectInfo *ai,
			     Array<CT_AdviceDecl*> &order_nodes);
      void collect_advice (CClassDatabase &db, ACAspectInfo *ai,
			   Array<CT_AdviceDecl*> &advice_nodes);
      void collect_intros (Plan &plan, CClassDatabase &db, AspectInfo *ai,
         ACAspectInfo *acai);
      void join_points (CTranslationUnit &, PointCutContext &);

   public:

      Transformer (VerboseMgr &vm, ErrorStream &e, CProject &p, Repository &r,
                   ACConfig &c, LineDirectiveMgr &ldm):
      	_vm (vm), _err (e), _project (p), _repo (r), _code_weaver (e, ldm),
      	_sem_visitor (e), _conf (c) {}
      void work (Unit *unit, Token *primary_start, Token *primary_end);
 };

#endif // __Transformer_h__
