// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __AdviceInfo_h__
#define __AdviceInfo_h__

#include <iostream>
using namespace std;

#include "PointCut.h"
#include "AdviceCode.h"
#include "BackEndProblems.h"
using namespace Puma;

class AspectInfo;

class AdviceInfo {
 
  AspectInfo *_aspect;
  PointCut _pointcut;
  AdviceCode *_code;

public:
  AdviceInfo (AspectInfo *ai, AdviceCode *code) : _aspect (ai), _code (code) {}
  AspectInfo *aspect () { return _aspect; }
  PointCut &pointcut () { return _pointcut; }
  AdviceCode &code () { return *_code; }

  void gen_invocation_func (ostream &out, bool def);
  void gen_invocation_func_call (ostream &stmt, const char* tjp_tp,
                                 const char *tjp_obj);

  void gen_binding_template (ostream &out, const char *jpname,
                             const BackEndProblems &bep);
  
  CScopeInfo *Scope () { return _code->Scope (); }
  const char *name () { return _code->name (); }
  advice_type type () { return _code->type (); }
};

#endif // __AdviceInfo_h__
