import nautilus, subprocess, os, gettext

from gettext import gettext as _
gettext.textdomain("arkose-nautilus")

class SandboxExtension(nautilus.MenuProvider):
    def __init__(self):
        return

    def menu_activate_cb(self, menu, file):
        path=file.get_uri().replace('file://','')
        subprocess.Popen(['arkose-gui',path])
        return

    def get_file_items(self, window, files):
        if len(files) != 1:
            return

        if files[0].is_directory():
            return
        if files[0].get_uri_scheme() != "file":
            return
        path=files[0].get_uri().replace('file://','')

        if not os.path.exists(path) or not os.access(path, os.X_OK):
            return

        item = nautilus.MenuItem('NautilusPython::openterminal_file_item',
                                 _('Open in a sandbox') ,
                                 _('Open %s in a sandbox') % files[0].get_name())
        item.connect('activate', self.menu_activate_cb, files[0])
        return [item]
