#ifndef _STRUCTURE_TREE_H_
#define _STRUCTURE_TREE_H_

#include "../headers.h"
#include "../support/gstring.h"
#include "../support/gpath.h"
#include "../externs.h"
#include "core.h"

#ifdef DEBUG_ON
//    #define TREE_DEBUG
//    #define TREE_DEBUG_DEEP
#endif

struct node {

    struct stats *stats;
    int size;
    int capacity;
    struct node **children;
    char *name;
    
};

void tree_set_root();

int tree_add_file(struct stats *);

int tree_delete(const char *);

char** tree_get_children(const char *);

int tree_get_file(const char *, struct stats **);

#endif
