#!/bin/sh
### BEGIN INIT INFO
# Provides:          apt-proxy
# Required-Start:    $remote_fs
# Required-Stop:     $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Debian archive proxy and partial mirror builder
### END INIT INFO

PATH=/sbin:/bin:/usr/sbin:/usr/bin

rundir=/var/run/apt-proxy/ 
pidfile=$rundir/apt-proxy.pid 
logfile=/var/log/apt-proxy.log
application=/usr/sbin/apt-proxy
process=$(basename $application)
twistd=/usr/bin/twistd
user=aptproxy
group=nogroup

. /lib/lsb/init-functions

[ -r /etc/default/apt-proxy ] && . /etc/default/apt-proxy

test -x $twistd || exit 0
test -r $application || exit 0

# return true if at least one pid is alive
alive()
{
    if [ -z "$*" ]; then
	return 1
    fi
    for i in $*; do
	if kill -0 $i 2> /dev/null; then
	    return 0
	fi
    done

    return 1
}


case "$1" in
    start)
	log_daemon_msg "Starting apt-proxy"
	[ ! -d $rundir ] && mkdir $rundir
	[ ! -f $logfile ] && touch $logfile
	chown $user $rundir $logfile 
	[ -f $pidfile ] && chown $user $pidfile
	# Make cache files readable
	umask 022
	start-stop-daemon --start --quiet --exec $twistd -- \
            --pidfile=$pidfile 	--rundir=$rundir --python=$application \
	    --logfile=$logfile 	--no_save
        # check if process is actually running
        sleep 1 # for some startup time and then check
        ps  -U "$user" -o cmd | grep -q "^$process"

	log_end_msg $?
    ;;

    stop)
	log_daemon_msg "Stopping apt-proxy"
	start-stop-daemon --stop --quiet --pidfile $pidfile
	#
	# Continue stopping until daemon finished or time over
	#
	count=0
	pid=$(cat $pidfile 2>/dev/null)
	while alive $pid; do
		if [ $count -gt 20 ]; then
			log_progress_msg " aborted"
			break;
		elif [ $count = 1 ]; then
			log_progress_msg " [wait $count"
		elif [ $count -gt 1 ]; then
			log_progress_msg " $count"
		fi
		count=$(expr $count + 1)
		sleep 1
		start-stop-daemon --stop --quiet --pidfile $pidfile
	done
	if [ $count -gt 1 ]; then
		log_progress_msg "]"
	fi
	log_end_msg $?
    ;;

    restart)
	$0 stop
	$0 start
    ;;
    
    force-reload)
        $0 restart
    ;;

    *)
	log_success_msg "Usage: /etc/init.d/apt-proxy {start|stop|restart|force-reload}"
	exit 1
    ;;
esac

exit 0
