#! /usr/bin/perl

# this are hook methods overload the hooks in apt-cacher-lib.pl and implement
# data checksumming methods

use DBI;
use Fcntl ':flock';
use IO::Handle;
use POSIX;
use Digest::MD5 qw(md5_hex);


my $ctx;
my $dbfile;
my $dbh;
my $dblck;

sub dbauf {
   open($dblck, $dbfile);
   flock($dblck, LOCK_EX);
   $dbh = DBI->connect("dbi:SQLite:dbname=$dbfile","", "",
   { RaiseError => 1, AutoCommit => 0 } );
}

sub dbzu {
   $dbh->disconnect;
   flock($dblck, LOCK_UN);
   close($dblck);
}

# arg: filename
sub store_sum {
    debug_message("Saved checksum for $_[0]");
    dbauf();
    $dbh->do('REPLACE INTO sums VALUES(?,?);', undef, shift, $ctx->hexdigest);
    $dbh->commit;
    dbzu();
}

# arg: file to be scanned and added to DB
sub import_sums {
   my %sumhash;
   extract_sums(shift, \%sumhash);
   dbauf();
   for(keys %sumhash) {
     debug_message("Import checksum for $_");
     $dbh->do("replace into sums values(?,?);",undef,$_,$sumhash{$_});
   }
   $dbh->commit;
   dbzu();
}

sub db_init {
   $dbfile=shift;
   if(-z $dbfile) {
      open $db, ">$dbfile"|| die "Failed to create $dbfile."; close $db; # touch it
      dbauf();
      $dbh->do("CREATE TABLE sums (file varchar PRIMARY KEY, sum varchar(32) NOT NULL);");
      $dbh->commit;
      dbzu();
   }
}

# purpose: create hasher object
sub data_init {
   $ctx = Digest::MD5->new;
   return 1;
}

# purpose: append data to be scanned
sub data_feed {
   $ref=shift;
   $ctx->add($$ref);
}

# arg: filename
sub check_sum {
   my $file = shift;
   my $digest = $ctx->hexdigest;
   dbauf();
   my @sqlar = $dbh->selectrow_array("select sum from sums where file=?", undef, $file);
   dbzu();
   if(defined($sqlar[0]) && $sqlar[0] ne '') {
       # FIXME: do not check SHA1 summs, not supported yet
       return 1 if(length($sqlar[0]) == 40);

       # now find the faulty deb
       debug_message("Verify $file: db $sqlar[0], file $digest");
       return ($sqlar[0] eq $digest);
   }
   debug_message("No stored checksum found for $file. Ignoring");
   return 1;
}

# arg: filename
sub delete_sum {
  db_do("delete from sums where file=?", undef, shift);
}

#args: array passed to DBI->do
sub db_do {
  dbauf();
  $dbh->do(@_) || die $dbh->errstr;
  $dbh->commit;
  dbzu();
}

#arg: SELECT stanza
sub db_select {
  my $ret;
  dbauf();
  $ret=$dbh->selectall_arrayref(@_) || die $dbh->errstr;
  dbzu();
  return $ret;
}

1;
