
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>

#include <vector>
//#include <iostream>

#include "meta.h"
#include "dirwalk.h"

using namespace MYSTD;

struct dnode
{
	dnode(dnode *parent) : m_parent(parent) {};
	bool Walk(IFileHandler *);

	MYSTD::string sPath;
	dnode *m_parent;
	struct stat m_stinfo;
	
private:
	// not to be copied
	dnode& operator=(const dnode&);
	dnode(const dnode&);

};

bool dnode::Walk(IFileHandler *h)
{
	if (stat(sPath.c_str(), &m_stinfo) < 0)
		return true; // slight risk of missing information here... bug ignoring is safer
	
	if(S_ISREG(m_stinfo.st_mode))
		return h->ProcessRegular(sPath, m_stinfo);
	else if(! S_ISDIR(m_stinfo.st_mode))
	{
		return h->ProcessOthers(sPath, m_stinfo);
	}
	
	// ok, that's a directory, scan it and descend where needed
	// seen this in the path before? symlink cycle?
	for(dnode *cur=m_parent; cur!=NULL; cur=cur->m_parent)
	{
		if (m_stinfo.st_dev == cur->m_stinfo.st_dev && m_stinfo.st_ino == cur->m_stinfo.st_ino)
			return true;
	}
	
//	cerr << "Opening: " << sPath<<endl;
	DIR *dir = opendir(sPath.c_str());
	if (!dir) // weird, whatever... ignore...
		return true;
	
	struct dirent *dp;
	dnode childbuf(this);
	bool bRet(true);
	
	while ( NULL != (dp = readdir(dir)) )
	{
		if (strcmp(dp->d_name, ".") && strcmp(dp->d_name, ".."))
		{
			childbuf.sPath=sPath+string(SZPATHSEP)+dp->d_name;
			bRet=childbuf.Walk(h);
			if(!bRet)
				goto stop_walk;
		}
	}
	
	
//	cerr << "Closing: " << sPath<<endl;
	stop_walk:
	if(dir)
		closedir(dir);
	return bRet;
}



bool DirectoryWalk(string & sRoot, IFileHandler *h)
{
	dnode root(NULL);
	root.sPath=sRoot; 
	return root.Walk(h);
}

