/*
 * bgtask.cpp
 *
 *  Created on: 18.09.2009
 *      Author: ed
 */

#include "bgtask.h"

#include "lockable.h"
#include "acfg.h"
#include "meta.h"
#include "filereader.h"

#include <limits.h>
#include <errno.h>

using namespace MYSTD;

bool bSigTaskAbort=false;
pthread_mutex_t abortMx=PTHREAD_MUTEX_INITIALIZER;

time_t nMaintId(0), nLastId(0);
lockable idLock;


bgtask::bgtask(int fd) : maintenance(fd), m_repFileStream(NULL)
{

}

bgtask::~bgtask()
{
	if(m_repFileStream)
	{
		forceFclose(m_repFileStream);
		m_repFileStream=0;
	}
}


/*
 *  TODO: this is kept in expiration class for historical reasons. Should be moved to some shared upper
 * class, like "detachedtask" or something like that
 */
void bgtask::Run(const string &cmd)
{

	if (cmd.find("&sigabort")!=stmiss)
	{
		lockguard g(&abortMx);
		bSigTaskAbort=true;
		const char hs[]="HTTP/1.1 302 Redirect\r\nLocation: ";
		const char head[] = "\r\nConnection: close\r\n\r\n";
		tStrPos nQuest=cmd.find("?");
		if(nQuest==stmiss)
			return; // whatever
		_SendHelper(hs, sizeof(hs)-1, MSG_MORE);
		_SendHelper(cmd.c_str(), nQuest, MSG_MORE);
		_SendHelper(head, sizeof(head)-1, MSG_MORE);
		return;
	}

	SendDecoration(true, "200", m_szDecoFile);

	static lockable onlyOneCanRun;

	if(!onlyOneCanRun.tryLock())
	{
		if(cmd.find("&readonly")==stmiss)
		{
			string msg("<font color=blue>A maintenance task is already running!</font><br>\n"
					"<ul><li><a href=");
			msg+=cmd+"&readonly#bottom";
			msg+=">View current log messages</a></li><li><a href=/";
			msg+=acfg::reportpage+">Return to main page</a></li></ul>"+
			"<p>(<a href="+cmd+"&sigabort>Abort current task ASAP</a>)";

			SendMsg(msg);
		}
		else
		{
			time_t id(0);
			{
				lockguard g(idLock);
				id=nMaintId;
			}
			DumpLog(id);
			string msg("<br>\n<a name=bottom>To be continued... (reload this page to see recent output)<br><a href=/");
			msg	+=acfg::reportpage+">Return to main page</a>\n";
			SendMsg(msg);

		}
	}
	else
	{
		// locking worked but not intended to act now
		if(cmd.find("&readonly")!=stmiss)
		{
			string msg("<font color=blue>Previous maintainenance task is completed!</font><br>\n"
						"<ul><li><a href=/");
			msg	+=acfg::reportpage+">Return to main page</a></li></ul><p>Last log contents:<br>\n";
			SendMsg(msg);

			DumpLog(nLastId);
		}
		else
		{
			/*****************************************************
			 * This is the worker part
			 *****************************************************/
			{
				lockguard g(idLock);
				nMaintId=time(NULL);
			}

			char buf[PATH_MAX];
			snprintf(buf, sizeof(buf), "%s"SZPATHSEP"maint_%lu.log",
					acfg::logdir.c_str(), nMaintId);
			m_repFileStream=fopen(buf, "w");

			{
				lockguard g(&abortMx);
				bSigTaskAbort=false;
			}

			SendMsg("Starting maintenance task, apt-cacher-ng version: " ACVERSION ".<br />");

			Action(cmd);

			{
				lockguard g(&abortMx);
				bSigTaskAbort=false;
			}

			SendMsg(string("<br>\n<a href=\"/")+acfg::reportpage
					+"\">Return to main page</a>");

			{
				lockguard g(idLock);
				nLastId=nMaintId;
				nMaintId=0;
			}

			if(m_repFileStream)
			{
				fclose(m_repFileStream);
				m_repFileStream=0;
			}
		}
		onlyOneCanRun.unlock();
	}
	SendDecoration(false, "", m_szDecoFile);
}

bool bgtask::CheckAbortCondition()
{
	lockguard g(&abortMx);
	return bSigTaskAbort;
}



void bgtask::DumpLog(time_t id)
{
	filereader reader;
	size_t size;
	const char *data(NULL);

	if (id<=0)
		goto log_na;

	char buf[PATH_MAX];
	snprintf(buf, sizeof(buf), "%s"SZPATHSEP"maint_%lu.log",
			acfg::logdir.c_str(), id);
	if (!reader.OpenFile(buf))
		goto log_na;

	data=reader.GetBuffer(size);
	maintenance::SendMsg(data, size);
	return;

	log_na:
	SendMsg(string("Log not available"));
}

void bgtask::SendMsg(const string &x)
{
	if (m_repFileStream)
	{
		fwrite(x.data(), sizeof(char), x.length(), m_repFileStream);
		fflush(m_repFileStream);
	}
	maintenance::SendMsg(x);
}

time_t bgtask::GetTaskId()
{
	return nMaintId;
}
