

#define LOCAL_DEBUG
#include "debug.h"
// doesn't work here without logging, force ignore
#undef ldbg

#include "acfg.h"
#include "filereader.h"

#ifdef HAS_WORDEXP
#include <wordexp.h>
#endif

#include <iostream>
#include <fstream>
#include <string>
#include <meta.h>
#include <list>
#include <map>
#include <algorithm>

using namespace MYSTD;

namespace acfg {

// always the same
string cachedir("/var/tmp"), logdir("/var/tmp"), fifopath, pidfile, proxy, reportpage, confdir;
string pfilepat(".*(\\.deb|\\.rpm|\\.dsc|\\.tar\\.gz|\\.diff\\.gz|\\.diff\\.bz2|"
		"\\.udeb|\\.diff/.*\\.gz|vmlinuz|initrd\\.gz)$");
string ifilepat("(^|.*?/)(Index|Packages\\.gz|Packages\\.bz2|Release|Release\\.gpg|"
		"Sources\\.gz|Sources\\.bz2|release|index\\.db-.*\\.gz|Contents-[^/]*\\.gz|"
		"pkglist[^/]*\\.bz2|rclist[^/]*\\.bz2|Translation[^/]*\\.bz2)$");

int offlinemode(false), verboselog(true), stupidfs(false), forcemanaged(false), extreshhold(20), tpoolsize(2);
int dnscachetime(1800), dlbufsize(70000);
string agentname("Debian Apt-Cacher-NG/" ACVERSION);
string remoteport("80");

#ifdef DEBUG
int port(3142), debug(3), foreground(true), verbose(true);
//string cachedir("/var/cache/acng"), logdir("/var/log/acng"), fifopath, pidfile;
#else
int port(3142), debug(0), foreground(false),  verbose(false);
#endif

// internal stuff:
char alphabet[65] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
tHttpUrl proxy_info; // abuses path member for auth data
string sPopularPath("/debian/");

typedef struct { const char *name; string *ptr; } MapNameToString; 
typedef struct { const char *name; int *ptr; } MapNameToInt;

MapNameToString n2sTbl[] = {
		{  "CacheDir", 	&cachedir }
		,{ "LogDir", 	&logdir }
		,{ "SocketPath", 	&fifopath}
		,{ "PidFile", 	&pidfile}
		,{ "Proxy",		&proxy}
		,{ "ReportPage",&reportpage}
		,{ "IfilePattern", &ifilepat}
		,{ "PfilePattern", &pfilepat}
};

MapNameToInt n2iTbl[] = {
		{  "Port", 			&port }
		,{ "Debug", 		&debug }
		,{ "OfflineMode", 	&offlinemode }
		,{ "ForeGround", 	&foreground }
		,{ "Verbose", 		&verbose }
		,{ "ForceManaged", 	&forcemanaged }
		,{ "StupidFs", 		&stupidfs }
		,{ "VerboseLog",	&verboselog }
		,{ "ExTreshold",	&extreshhold} 
		,{ "MaxSpareThreadSets",	&tpoolsize}
		,{ "DnsCacheSeconds",&dnscachetime}
};

#define _iterPos(it, start) (it-start.begin())/sizeof(it)
#define sProblemLoc szPath<< ':'<< _iterPos(it, lines)

string sFilterSet(SPACECHARS "#");
#define IsValidButIrrelevantLine(x) (x.empty() || stmiss != sFilterSet.find(x[0]))
#define BARF(x) { cerr << x << endl; exit(EXIT_FAILURE); }

void _ReadRewriteFiles(const string & sFile, const string & sRepName);
void _ReadBackendsFiles(const string & sFile, const string &sRepName);


struct fct_lt_host
{
  bool operator()(const tHttpUrl &a, const tHttpUrl &b) const
  {
    return strcasecmp(a.sHost.c_str(), b.sHost.c_str()) < 0;
  }
};
typedef multimap<tHttpUrl,const string*, fct_lt_host> tMapUrl2StringPtr; 
typedef tMapUrl2StringPtr::iterator tUrl2RepIter;
tMapUrl2StringPtr mapUrl2pVname;

typedef map<const string, tHostiVec> tMapString2Hostivec;
tMapString2Hostivec mapRepName2Backends;

string * _GetStringPtr(const string &key)  {
	for(unsigned int i=0; i<_countof(n2sTbl); i++) {
		if(0==strcasecmp(key.c_str(), n2sTbl[i].name))
			return n2sTbl[i].ptr;
	}
	return NULL;
}

int * _GetIntPtr(const string &key)  {
	for(unsigned int i=0; i<_countof(n2iTbl); i++) {
		if(0==strcasecmp(key.c_str(), n2iTbl[i].name))
			return n2iTbl[i].ptr;
	}
	return NULL;
}

inline void _FixPostPreSlashes(string &val)
{
	// fix broken entries

	if (val.empty() || val.at(val.length()-1) != '/')
		val.append("/");
	if (val.at(0) != '/')
		val.insert(0, "/", 1);
}

bool _ReadMainConfiguration(const char * szFilename)
{

	filereader reader;
	reader.OpenFile(szFilename);
	reader.CheckGoodState(true);
	string sLine, key, val;
	for (bool bNotEof=true; bNotEof;)
	{
		bNotEof=reader.GetOneLine(sLine);
		if (IsValidButIrrelevantLine(sLine))
			continue;
		if (_ParseLine(sLine, key, val))
		{
			SetOption(key, val);
			if (verbose)
				cout << key << " -> "<< val <<endl;
		}
	}
	return true;
}

const string * _CheckBEentryGetNamePtr(const string & sRepName)
{
	// needs a reliably stored string for the pointer. Backend description may not exist,
	// then create a dummy one with no contents and point at this string. Iterators on map are
	// guaranteed to be stable so point at its key variable.
	tMapString2Hostivec::iterator
			itHostiVec = mapRepName2Backends.find(sRepName);
	if (itHostiVec == mapRepName2Backends.end())
	{
		mapRepName2Backends[sRepName]=tHostiVec(0);
		itHostiVec=mapRepName2Backends.find(sRepName); // must refer to that string on the heap
		if (verbose)
			cout << "created empty backend entry for "<< sRepName <<endl;
	}
	return & itHostiVec->first;
}

inline void _AddRemapInfo(bool bAsBackend, const string & token,
		const string &repname)
{
	if (0!=token.compare(0, 5, "file:"))
	{
		tHttpUrl url;
		if(! url.SetHttpUrl(token))
			BARF(token + " <-- bad URL detected");
		_FixPostPreSlashes(url.sPath);
		
		if (bAsBackend)
			mapRepName2Backends[repname].push_back(url);
		else
			mapUrl2pVname.insert(pair<tHttpUrl,const string*>(
					url, _CheckBEentryGetNamePtr(repname)));
	}
	else
	{
		string sPath=token.substr(5);
		if (sPath.empty())
			BARF("Bad file spec for repname, file:?");
		
		if (sPath[0]!=cPathSep)
			sPath.insert(0, confdir+sPathSep);

		// TODO: does it support glob? Use glob instead?
#ifdef HAS_WORDEXP
		wordexp_t p;
		wordexp(sPath.c_str(), &p, 0);
		for (UINT i=0; i<p.we_wordc; i++)
		{
			if (bAsBackend)
				_ReadBackendsFiles(p.we_wordv[i], repname);
			else
				_ReadRewriteFiles(p.we_wordv[i], repname);
		}
		wordfree(&p);
#else
		 
		if (bAsBackend)
			_ReadBackendsFiles(sPath, repname);
		else
			_ReadRewriteFiles(sPath, repname);
#endif
	}
}

void SetOption(const MYSTD::string &key, const MYSTD::string &value)
{
	if(key.empty())
		return;
	string * sTarget;
	int * nTarget;
	if ( NULL != (sTarget = _GetStringPtr(key)))
		*sTarget=value;
	else if ( NULL != (nTarget = _GetIntPtr(key)))
		*nTarget=atoi(value.c_str());
	else if(0==strncasecmp(key.c_str(), "Remap-", 6))
	{
		string vname=key.substr(6, key.npos);
		tStrVec tokens;
		
		Tokenize(value, SPACECHARS, tokens);
		if(tokens.empty() || vname.empty())
		{
			cerr << "Found invalid entry, ignoring " << key << ": " << value <<endl;
			return;
		}
		bool bIsBackend=false;
		for(UINT i=0; i<tokens.size(); i++)
		{
			if(tokens[i]==";")
			{
				bIsBackend=true;
				continue;
			}
			_AddRemapInfo(bIsBackend, tokens[i], vname);
		}
		
	}
	else
		cerr << "Warning, unknown configuration directive: " << key <<endl;
}


//const string * GetVnameForUrl(string path, string::size_type * nMatchLen)
const string * GetRepNameAndPathResidual(const tHttpUrl in, MYSTD::string & sRetPathResidual)
{
	sRetPathResidual.clear();
	
	pair<tUrl2RepIter,tUrl2RepIter> range=mapUrl2pVname.equal_range(in);
	if(range.first==mapUrl2pVname.end())
		return NULL;
	
	tStrPos bestMatchLen(0);
	string const * psBestHit(NULL);
		
	for (tUrl2RepIter & it=range.first; it!=range.second; it++)
	{
		// rewrite rule path must be a real prefix
		// it's also surrounded by /, ensured during construction
		const string & prefix=it->first.sPath;
		tStrPos len=prefix.length();
		if (in.sPath.size() > len && 0==in.sPath.compare(0, len, prefix))
		{
			if (len>bestMatchLen)
			{
				bestMatchLen=len;
				psBestHit=it->second;
			}
		}
	}
		
	if(psBestHit) sRetPathResidual=in.sPath.substr(bestMatchLen);
	return psBestHit;
	
}

tHostiVec * GetBackendVec(const string * vname)
{
	if(!vname)
		return NULL;
	tMapString2Hostivec::iterator it=mapRepName2Backends.find(*vname);
	if(it==mapRepName2Backends.end() || it->second.empty())
		return NULL;
	return & it->second;
}


void _ReadBackendsFiles(const string & sFile, const string &sRepName)
{
	filereader reader;
	reader.OpenFile(sFile.c_str());
	
	if(verbose)
		cout << "Reading file: " << sFile <<endl;
	if(!reader.CheckGoodState(false))
	{
		if(verbose)
			cout << "No backend data found, file ignored."<<endl;
		return;
	}
	
	string sLine, key, val;
	tHttpUrl entry;
	
	for(bool bNotEof=true;bNotEof;) {
		
		bNotEof=reader.GetOneLine(sLine);
		//if(debug)
		//	cerr << "backends, got line: " << sLine <<endl;
		

		if(0==sLine.compare(0, 7, "http://") && entry.SetHttpUrl(sLine))
		{
			_FixPostPreSlashes(entry.sPath);
			mapRepName2Backends[sRepName].push_back(entry);
#ifdef DEBUG
			cerr << "Backend: " << sRepName << " <-- " << entry.ToString() <<endl;
#endif			
		}
		else if(_ParseLine(sLine, key, val))
		{
			if(keyEq("Site", key))
				entry.sHost=val;
			/* TODO: not supported yet, maybe add later - push to a vector of hosts and add multiple later
			if(keyEq("Aliases", key))
			{
				val+=" ";
				for(string::size_type posA(0), posB(0);
					posA<val.length();
					posA=posB+1)
				{
					posB=val.find_first_of(" \t\r\n\f\v", posA);
					if(posB!=posA)
						hosts.push_back(val.substr(posA, posB-posA));
				}
			}
			*/
			else if(keyEq("Archive-http", key) || keyEq("X-Archive-Http", key))
			{
				_FixPostPreSlashes(val);
				entry.sPath=val;
			}
		
		}
		else if(IsValidButIrrelevantLine(sLine))  
		{
			mapRepName2Backends[sRepName].push_back(entry);

		}
		else
		{
			cerr << "Bad backend description, around line "
					<< reader.GetPositionDescription() << endl;
			exit(2);
		}
	}
}

void _ReadRewriteFiles(const string & sFile, const string & sRepName)
{

	filereader reader;
	if(verbose)
		cout << "Reading file: " << sFile <<endl;
	reader.OpenFile(sFile.c_str());
	reader.CheckGoodState(true);

	
	tStrVec hosts, paths;
	string sLine, key, val;
	
	for(bool bNotEof=true;bNotEof;)
	{
		bNotEof=reader.GetOneLine(sLine);
		
		if (IsValidButIrrelevantLine(sLine)) // end of block, eof, ... -> commit it
		{
			if (hosts.empty() && paths.empty())
				continue; // dummy run
			if ( !hosts.empty() && paths.empty())
				paths.push_back("/");
			if ( !paths.empty() && hosts.empty())
			{
				cout << "Parse error, missing Site: field around line "
						<< reader.GetPositionDescription() <<endl;
				exit(2);
			}
			for (tStrVec::const_iterator itHost=hosts.begin(); 
			itHost!=hosts.end(); 
			itHost++)
			{
				for (tStrVec::const_iterator itPath=paths.begin(); 
				itPath!=paths.end(); 
				itPath++)
				{
					//mapUrl2pVname[*itHost+*itPath]= &itHostiVec->first;
					tHttpUrl url;
					url.sHost=*itHost;
					url.sPath=*itPath;
					pair<tHttpUrl,const string*> info(url, _CheckBEentryGetNamePtr(sRepName));
					mapUrl2pVname.insert(info);
/*
					if (debug)
						cout << "Mapping: "<< *itHost << ""<< *itPath 
						<< " -> "<< itHostiVec->first<<endl;
*/
				}
			}
			hosts.clear();
			paths.clear();
			continue;
		}
		else if(!_ParseLine(sLine, key, val))
		{
			cerr << "Error parsing rewrite definitions, around line " << reader.GetPositionDescription() <<endl;
			exit(1);
		}
		
		// got something, intepret it...
		
		if( keyEq("Site", key) || keyEq("Alias", key) || keyEq("Aliases", key))
			Tokenize(val, SPACECHARS, hosts);
		if(keyEq("Archive-http", key) || keyEq("X-Archive-http", key))
		{
			// help STL saving some memory
			if(sPopularPath==val)
				paths.push_back(sPopularPath);
			else
			{
				_FixPostPreSlashes(val);
				paths.push_back(val);
			}
			continue;
		}
	}
}

void ReadConfigDirectory(const char *szPath)
{
	// TODO: early abort when the dir does not exist!

	char buf[PATH_MAX];
	realpath(szPath, buf);
	confdir=buf; // pickup the last config directory

#ifdef HAS_WORDEXP
	wordexp_t p;
    wordexp((confdir+"/*.conf").c_str(), &p, 0);
    for (UINT i=0; i<p.we_wordc; i++)
    	_ReadMainConfiguration(p.we_wordv[i]);
    wordfree(&p);
#else
    _ReadMainConfiguration((confdir+cPathSep+"acng.conf").c_str());
#endif

}

string _GetBase64Auth(const string & sUserColonPass)
{
	int cols, bits, c, char_count;

	char_count = 0;
	bits = 0;
	cols = 0;
	tStrPos pos(0);
	MYSTD::string out("Proxy-Authorization: Basic ");
	while ( pos<sUserColonPass.size())
	{
		c=sUserColonPass[pos++];
		bits += c;
		char_count++;
		if (char_count == 3)
		{
			out+=(alphabet[bits >> 18]);
			out+=(alphabet[(bits >> 12) & 0x3f]);
			out+=(alphabet[(bits >> 6) & 0x3f]);
			out+=(alphabet[bits & 0x3f]);
			cols += 4;
			bits = 0;
			char_count = 0;
		}
		else
		{
			bits <<= 8;
		}
	}
	if (char_count != 0)
	{
		bits <<= 16 - (8 * char_count);
		out+=(alphabet[bits >> 18]);
		out+=(alphabet[(bits >> 12) & 0x3f]);
		if (char_count == 1)
		{
			out+=('=');
			out+=('=');
		}
		else
		{
			out+=(alphabet[(bits >> 6) & 0x3f]);
			out+=('=');
		}
	}
	return out+"\r\n";
}

void PostProcConfig() 
{
	/*
	// make all access paths list be sorted by descending length, the more exact ones shall be found first
	for(tMapSitePath2iter::iterator it=RewMap.begin(); it!=RewMap.end(); it++)
		sort(it->second.begin(), it->second.end(), longer_path_fct());
		*/
	
    // postprocessing

   if(cachedir.empty() || cachedir[0] != sPathSep[0]) {
      cerr << "Cache directory unknown or not absolute, terminating..." <<endl;
      exit(EXIT_FAILURE);
   }
   // get rid of duplicated and trailing slash(es)
   tStrVec tmp;
   Tokenize(cachedir, sPathSep.c_str(), tmp);
   Join(cachedir, sPathSep, tmp);
   
   if(!pidfile.empty() && pidfile[0] != sPathSep[0])
   {
	   cerr << "Pid file path must be absolute, terminating..."  <<endl;
	         exit(EXIT_FAILURE);
   }
   
   if(! proxy.empty()) {
	   if(!proxy_info.SetHttpUrl(proxy))
	   {
		   cerr << "Invalid proxy specification, aborting..." << endl;
		   exit(EXIT_FAILURE);
	   }
	   
	   tStrPos pos=proxy_info.sHost.find('@');
	   if(stmiss != pos)
	   {
		   proxy_info.sPath=_GetBase64Auth(proxy.substr(0, pos));
		   proxy_info.sHost.erase(0,pos+1);
	   }
	   if(proxy_info.sHost.empty())
	   {
		   cerr << "Invalid proxy specification, aborting..." << endl;
		   exit(EXIT_FAILURE);
	   }
	   if (proxy_info.sPort.empty())
		{
			if (proxy_info.sPath.empty()) // guess unless there is any risk...
			{
				cerr << "Warning, unknown proxy port, assuming 80." <<endl;
				proxy_info.sPort="80";
			}
			else
			{
				cerr << "Error, unknown proxy port!"<<endl;
				exit(EXIT_FAILURE);
			}
	   }
   }
   
   // create working paths before something else fails somewhere
   if(!fifopath.empty())
	   mkbasedir(acfg::fifopath);
   if(!cachedir.empty())
	   mkbasedir(acfg::cachedir);
   if(! pidfile.empty())
	   mkbasedir(acfg::pidfile);
   
   /*
   // help STL saving some memory
   for(tUrl2RepIter it=mapUrl2pVname.begin(); it!=mapUrl2pVname.end(); it++)
   {
	   tUrl2RepIter suc=it;
	   suc++;
	   if(suc==mapUrl2pVname.end()) break;
	   if(suc->first.sPath==it->first.sPath)
		   const_cast<string&>(suc->first.sPath)=it->first.sPath;
   }
   */
}
}



#ifdef CODETHATSUCKS

/*
struct longer_path_fct {
	bool operator()(const tPairPathBackendit & x, const tPairPathBackendit & y) const
	{
		cout << "comp: " << x.first << " vs. " << y.first <<endl;
		return (x.first.length() < y.first.length());
	}
};
*/


bool _ReadFileToStrVec(const char * szFilename, tStrVec & vecOut)
{
	if (verbose)
		cout << "Reading file: "<< szFilename << endl;

	ifstream iFile(szFilename);
	//iFile.exceptions ( ifstream::eofbit | ifstream::failbit | ifstream::badbit );
	if (!iFile.is_open())
	{
		perror("Error opening the configuration file");
		exit(1);
	}
	string line;
	//asm("int3");
	
	try
	{
		while (getline(iFile, line))
		{
			if(line.empty())
			{ // block ending? may be needed later
				vecOut.push_back(line);
				continue;
			}
			
			if (line.at(0)=='#') continue;
			
			if (line==" .")	line=" ";

			if (line.at(0) != ' '|| vecOut.size()<1) 
			{
				//if(debug) cerr << "Adding "<< line <<endl;
				vecOut.push_back(line);
			}
			else
			// something to append to the last element. Cheap solution, forget where the initial line ended.
			vecOut.back()+=(line+" ");
		}
		iFile.close();
	}
	catch(ifstream::failure ex)
	{
		//cerr << "IO error? " << ex.what()<<endl;
		perror("Error reading the configuration file");
		exit(1);
	}
	return true;
}

typedef map<string, tBackendSetDescription> tVirtSite2BackendDesc;
tVirtSite2BackendDesc RewMap;

// visible hostname, pool of associated backends (iterators in their map) refered by sub-directories,

/*typedef map<string, vector<tPairPathBackendit>, ltstring > tMapSitePath2iter;
tMapSitePath2iter RewMap;
*/


bool _GetOneMapBlock(tStrVec & vecLines, NoCaseStringMap & mapOut)
{
	while ( !vecLines.empty() )
	{
		string line=vecLines.front();
		vecLines.pop_front();
		trimFront(line);
		if(line.empty())
			return true; // got one block
		
		string::size_type pos = line.find(":");
		if (pos==string::npos)
		{
			cerr << "Bad configuration directive in "<< line << endl;
			return false;
		}
		string key=line.substr(0, pos);
		//cerr << "test: " << key;

		trimBack(key);
		line.erase(0, pos+1);
		trimFront(line);
		mapOut[key]=line;
	}
	return true;
}
/*
tFolder2BackendPtr::tFolder2BackendPtr(string sFolder, tHostInfo * backend) :
	m_sFolder(sFolder), m_backend(backend)
{
}

tBackendSetEntry * GetBackendSetDescription(const sRequestHostname)
{
	tVirtSite2BackendDesc::iterator it = RewMap.find(sRequestHostname);
	if(it==RewMap.end())
		return NULL;
	return it->second;
}

tHostInfo * tBackendSetDescription::GetMatchingBackendPtr(vector::size_type & nSearchStartPos,
			const string & sFilePath)
{
	
}
*/
#endif

/*
int main(int argc, char **argv)
{
	if(argc<2)
		return -1;
	
	acfg::tHostInfo hi;
	cout << "Parsing " << argv[1] << ", result: " << hi.SetUrl(argv[1])<<endl;
	cout << "Host: " << hi.sHost <<", Port: " << hi.sPort << ", Path: " << hi.sPath<<endl;
	return 0;
}
*/

