
#ifndef _CON_H
#define _CON_H

#include "config.h"
#include "lockable.h"
#include "rechecks.h"

#include <list>
#include <string>

#define RBUFLEN 16384

class dlcon;
class job;

class con;
typedef SHARED_PTR<con> tConPtr;

class con : public condition {
   public: 
      con(int fdId, const char *client);
      ~con();
      
      void WorkLoop();
      void HelpLoop();
      //! Tell running threads to stop
      void SignalStop();
      //! Terminate the connection gracefully
      void ShutDown();
      
   private:
	   con& operator=(const con&);// { /* ASSERT(!"Don't copy con objects"); */ };
	   con(const con&);// { /* ASSERT(!"Don't copy con objects"); */ };

      int m_confd;
      
      MYSTD::list<job*> m_jobs2prep, m_jobs2send;
      
      // to awake select with dummy data
      int wakepipe[2];
      
      bool m_bStopActivity;
      
      pthread_t m_dlerthr;
      
      // for jobs
      friend class job;
      bool SetupDownloader();
      dlcon * m_pDlClient;
      rechecks rex;
      MYSTD::string m_sClientHost;          
};

#endif
