/*
 *      stations.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include "ap-utils.h"

/*
 * NOTE: SBRIDGES seems to be currently handled by ap-gl =>
 * no SBRIDGES-related code here (yet)!
 */

#define TITLE_AP _("AP link state")

/* following for any non-VERNET ATMEL* MIB */
#define HEADER_STAS \
	_(" #            MAC                                               ")
/* following for VERNET-enhanced ATMEL12350 MIB */
#define HEADER_STAS_VERNET \
	_(" #     MAC       Parent MAC    RSSI  Status MACn      IP        ")

#define MAX_LINES LINES-4

extern int LINES;
extern WINDOW *main_sub;
extern short ap_type, ap_vendorext;
extern int sts_viewtype;

void atmel_stations()
{
    char bridgeOperationalMode[] = {
	0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x04, 0x01, 0x00
    };
    char StasNum[] = {
	0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x05, 0x01, 0x00
    };
    char StasMac[] = {
	0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x05, 0x02, 0x00
    };

    struct AssociatedSTAsInfo {
	unsigned short Num;
	unsigned char MacAddress[6];
	/* following ones are specific for enhanced ATMEL 12350 MIB by VERNET */
	unsigned char Status;
	unsigned char Port;
	unsigned char ParentMacAddress[6];
	unsigned char RSSI;
	unsigned char IP[4];
    } *mac = NULL, get;

    struct MacListStat *first = NULL, *curr = NULL;
    char message[1024];
    int mac_idx, begin, end, total_mac;
    varbind varbinds[1];

    if (ap_type == ATMEL12350) {
        bridgeOperationalMode[5] = 0xE0;
	bridgeOperationalMode[6] = 0x3E;
	StasNum[5] = 0xE0;
	StasNum[6] = 0x3E;
	StasMac[5] = 0xE0;
	StasMac[6] = 0x3E;
    }	

    /* find out in what mode the AP currently is */
    varbinds[0].oid = bridgeOperationalMode;
    varbinds[0].len_oid = sizeof(bridgeOperationalMode);
    varbinds[0].value = bridgeOperationalMode;
    varbinds[0].len_val = 0;
    varbinds[0].type = NULL_VALUE;
    print_help(WAIT_RET);
    if (snmp(varbinds, 1, GET) <= 0) {
	  print_helperr(ERR_RET);
	  goto exit;
    }

    /* for AP in AP-Client mode & without VERNET firmware, disable status */
    if (*(varbinds[0].value) == 3 && ap_vendorext != VERNET) {
	mvwaddstr(main_sub, 3, 1, _("AP is currently in AP Client Mode => "
	    "no associated STAtions."));
	print_help(ANY_KEY);
	wrefresh(main_sub);
	getch();
	goto exit;
    }

    noecho();
    wattrset(main_sub, COLOR_PAIR(3));
    if (ap_vendorext == VERNET)
	mvwaddstr(main_sub, 0, 0, HEADER_STAS_VERNET);
    else
	mvwaddstr(main_sub, 0, 0, HEADER_STAS);
    wattrset(main_sub, A_NORMAL);

refresh:
    /* find out how many STAtions is in the list */
    varbinds[0].oid = StasNum;
    varbinds[0].len_oid = sizeof(StasNum);
    varbinds[0].value = StasNum;
    varbinds[0].type = NULL_VALUE;
    varbinds[0].len_val = 0;

    print_help(WAIT_RET);

    if (snmp(varbinds, 1, GET) <= 0) {
	print_helperr(ERR_RET);
	getch();
	goto exit;
    }

    total_mac = *(varbinds[0].value);
    print_help(WAIT_SET);
    mac_idx = 1;
    while (mac_idx <= total_mac) {

	/* tell the AP we want first mac_idx-th MAC */
	varbinds[0].oid = StasMac;
	varbinds[0].len_oid = sizeof(StasMac);
	varbinds[0].type = INT_VALUE;
	get.Num = swap2(mac_idx);
	varbinds[0].value = (char *) &get;
	varbinds[0].len_val = sizeof(get);

	if (snmp(varbinds, 1, SET) <= 0) {
	    print_helperr(ERR_RET);
	    getch();
	    goto exit;
	}

	if (varbinds[0].len_val == 24) {
	    if (mac)
		free(mac);
	    mac =
		(struct AssociatedSTAsInfo *) malloc(varbinds[0].len_val);
	    memcpy(mac, varbinds[0].value, varbinds[0].len_val);
	    /* mac = (struct AssociatedSTAsInfo *) varbinds[0].value; */
	} else {
	    print_helperr(_("AssociatedSTAsInfo packet error"));
	    goto exit;
	}

	if (first == NULL) {
	    first =
		(struct MacListStat *) malloc(sizeof(struct MacListStat));
	    curr = first;
	} else {
	    curr->next =
		(struct MacListStat *) malloc(sizeof(struct MacListStat));
	    curr = curr->next;
	}

	memcpy(curr->addr, mac->MacAddress, 6);

	if (ap_vendorext == VERNET) {
	    curr->Status = mac->Status;
	    curr->Port = mac->Port;
	    memcpy(curr->ParentMacAddress, mac->ParentMacAddress, 6);
	    curr->rssi = mac->RSSI;
	    memcpy(&(curr->IP.s_addr), mac->IP, 4);
	}

	curr->next = NULL;
	mac_idx++;
    }

    begin = 1;
    end = (MAX_LINES < mac_idx) ? MAX_LINES : mac_idx;

    sprintf(message, "%s: %d", TITLE_STAS, total_mac);
    while (1) {
	if (ap_vendorext == VERNET) {
	    print_top_rssi(message);

	    print_help(_("Arrows - scroll; S - save to file; Q - return; "
			 "T - toggle view; Other - refresh"));
	    scroll_rows(first, begin, end, 1, 3);
	} else {
	    print_top(NULL, message);
	    print_help(_("Arrows - scroll; S - save to file; Q - return; "
			 "Other key - refresh"));
	    scroll_rows(first, begin, end, 1, 0);
	}

	switch (getch()) {
	    case 'S':
	    case 's':
		save_Stations(first);
		continue;
	    case KEY_RIGHT:
	    case KEY_DOWN:
		if (end < mac_idx) {
		    begin++;
		    end++;
		}
		continue;
	    case KEY_UP:
	    case KEY_LEFT:
		if (begin > 1) {
		    begin--;
		    end--;
		}
		continue;
	    case 'Q':
	    case 'q':
		goto exit;
	    case 'T':
	    case 't':
		if (ap_vendorext == VERNET) {
		    sts_viewtype += 1;
		    if (sts_viewtype == 3)
			sts_viewtype = 0;
		}
		continue;
	    default:
		while ((curr = first)) {
		    first = curr->next;
		    free(curr);
		}
		first = curr = NULL;
		goto refresh;
	}
    }

exit:
    while ((curr = first)) {
	first = curr->next;
	free(curr);
    }
    print_top(NULL, NULL);
    clear_main(0);
}

void nwn_stations()
{
    unsigned char Mac[] = {
	0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x03, 0x01,
	0x02, 0x01, 0x02, 0x80, 0x00 };
    unsigned char Quality[] = {
	0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x03, 0x01,
	0x02, 0x01, 0x03, 0x80, 0x00 };
    unsigned char Age[] = {
	0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x03, 0x01,
	0x02, 0x01, 0x04, 0x80, 0x00 };
    unsigned char RSSI[] = {
	0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x03, 0x01,
	0x02, 0x01, 0x05, 0x80, 0x00 };

    struct MacListStat *first = NULL, *curr = NULL;
    char null[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, message[1024];
    int mac_idx, begin, end;
    varbind varbinds[4];
    unsigned char next_num;


    mac_idx = 0;
    print_top(NULL, TITLE_STAS);
    mvwaddstr(main_sub, 0, 3,
	_("Id       MAC address     Quality  Age  RSSI"));
    noecho();
    print_help(WAIT_RET);

    varbinds[0].oid = Mac;
    varbinds[0].len_oid = sizeof(Mac);
    varbinds[0].len_val = 0;
    varbinds[0].type = NULL_VALUE;
    if (snmp(varbinds, 1, GET_NEXT) <= 0) {
        print_helperr(ERR_RET);
        goto exit;
    }
   next_num = varbinds[0].oid[varbinds[0].len_oid - 1];

   while (memcmp(varbinds[0].oid, Mac, sizeof(Mac) - 2) == 0) {

	Mac[sizeof(Mac) - 1] = next_num;
	Quality[sizeof(Mac) - 1] = next_num;
	Age[sizeof(Mac) - 1] = next_num;
	RSSI[sizeof(Mac) - 1] = next_num;

	if(sizeof(Mac) == varbinds[0].len_oid) {
		Mac[sizeof(Mac) - 2] = varbinds[0].oid[varbinds[0].len_oid - 2];
		Quality[sizeof(Mac) - 2] = varbinds[0].oid[varbinds[0].len_oid - 2];
		Age[sizeof(Mac) - 2]  = varbinds[0].oid[varbinds[0].len_oid - 2];
		RSSI[sizeof(Mac) - 2] = varbinds[0].oid[varbinds[0].len_oid - 2];
	}

	varbinds[0].oid = Mac;
	varbinds[0].len_oid = sizeof(Mac);
	varbinds[0].len_val = 0;
	varbinds[0].type = NULL_VALUE;
	varbinds[1].oid = Quality;
	varbinds[1].len_oid = sizeof(Quality);
	varbinds[1].len_val = 0;
	varbinds[1].type = NULL_VALUE;
	varbinds[2].oid = Age;
	varbinds[2].len_oid = sizeof(Age);
	varbinds[2].len_val = 0;
	varbinds[2].type = NULL_VALUE;
	varbinds[3].oid = RSSI;
	varbinds[3].len_oid = sizeof(RSSI);
	varbinds[3].len_val = 0;
	varbinds[3].type = NULL_VALUE;
	if (snmp(varbinds, 4, GET) <= 0) {
	    print_helperr(ERR_RET);
	    getch();
	    goto exit;
	}

	if (memcmp(null, varbinds[0].value, 6)) {
	    if (first == NULL) {
		first =
		    (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = first;
	    } else {
		curr->next =
		    (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = curr->next;
	    } 
	    memcpy(curr->addr, varbinds[0].value, 6);
	    curr->quality = *varbinds[1].value;
	    curr->idle = *varbinds[2].value;
	    curr->rssi = *varbinds[3].value;
	    curr->next = NULL;
	    mac_idx++;
	}

	varbinds[0].oid = Mac;
        varbinds[0].len_oid = sizeof(Mac);
        varbinds[0].len_val = 0;
        varbinds[0].type = NULL_VALUE;
        if (snmp(varbinds, 1, GET_NEXT) <= 0) {
            print_helperr(ERR_RET);
            goto exit;
        }
	next_num = varbinds[0].oid[varbinds[0].len_oid - 1];
						
    }

   if(mac_idx) {

    begin = 1;
    end = (MAX_LINES < mac_idx + 1) ? MAX_LINES : mac_idx + 1;

    while (1) {
	print_help(_("Arrows - scroll; S - save to file; Q - return; "
	    "T - toggle view; Other - refresh"));

	scroll_rows(first, begin, end, 1, 1);

	sprintf(message, "%s: %d", TITLE_STAS, mac_idx);
	print_top_rssi(message);

	switch (getch()) {
	case 'S':
	case 's':
	    save_Stations(first);
	    continue;
	case KEY_DOWN:
	case KEY_RIGHT:
	    if (end < mac_idx+1) {
		begin++;
		end++;
	    }
	    continue;
	case KEY_UP:
	case KEY_LEFT:
	    if (begin > 1) {
		begin--;
		end--;
	    }
	    continue;
	case 'Q':
	case 'q':
	    goto exit;
	case 'T':
	case 't':
	    sts_viewtype += 1;
	    if (sts_viewtype == 3)
		sts_viewtype = 0;

	    continue;
	}
    }
   }
   
   print_help(ANY_KEY);
   getch();
   
  exit:
    while ((curr = first)) {
        first = curr->next;
	free(curr);
    }
    
    print_top(NULL, NULL);
    clear_main(0);
}

