/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XMLERRORHANDLER_HPP
#define __XMLERRORHANDLER_HPP

#include <sax/ErrorHandler.hpp>
#include <string>

#ifdef XERCES_HAS_CPP_NAMESPACE
using namespace XERCES_CPP_NAMESPACE;
#endif
#ifdef XALAN_HAS_CPP_NAMESPACE
using namespace XALAN_CPP_NAMESPACE;
#endif

/** @addtogroup XMLCpp
    @{ */
/** Error-handler for Apache XML-library.
    @date Sun Jan 09 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class XMLErrorHandler: public ErrorHandler
{
public:
  ///
  XMLErrorHandler(void);
  ///
  void warning( const SAXParseException &toCatch );
  ///
  void error( const SAXParseException &toCatch );
  ///
  void fatalError( const SAXParseException &toCatch );
  ///
  void resetErrors();
  ///
  bool getErrorOccurred(void) const { return errorOccurred; }
  ///
  const std::string &getErrorMessage(void) const { return message; }
protected:
  ///
  void triggerError( const std::string &type,
                     const SAXParseException &toCatch );
  ///
  std::string createMessage( const std::string &type,
                             const SAXParseException &toCatch );
  ///
  bool errorOccurred;
  ///
  std::string message;
};

///@}

#endif
