/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <klocale.h>
#ifndef NDEBUG
#include <iostream>
#endif
#include "unitMap.hpp"

using namespace std;

map< string, string > createUnitMap(void)
{
  map< string, string > retVal;

  retVal[ ""                    ] = ""  ;
  retVal[ i18n( "per serving" ) ] = "x" ;
  retVal[ i18n( "small"       ) ] = "sm";
  retVal[ i18n( "medium"      ) ] = "md";
  retVal[ i18n( "large"       ) ] = "lg";
  retVal[ i18n( "can"         ) ] = "cn";
  retVal[ i18n( "package"     ) ] = "pk";
  retVal[ i18n( "pinch"       ) ] = "pn";
  retVal[ i18n( "drop"        ) ] = "dr";
  retVal[ i18n( "dash"        ) ] = "ds";
  retVal[ i18n( "carton"      ) ] = "ct";
  retVal[ i18n( "bunch"       ) ] = "bn";
  retVal[ i18n( "slice"       ) ] = "sl";
  retVal[ i18n( "each"        ) ] = "ea";
  retVal[ i18n( "teaspoon"    ) ] = "ts";
  retVal[ i18n( "tablespoon"  ) ] = "tb";
  retVal[ i18n( "fluid ounce" ) ] = "fl";
  retVal[ i18n( "cup"         ) ] = "c" ;
  retVal[ i18n( "pint"        ) ] = "pt";
  retVal[ i18n( "quart"       ) ] = "qt";
  retVal[ i18n( "gallon"      ) ] = "ga";
  retVal[ i18n( "ounce"       ) ] = "oz";
  retVal[ i18n( "pound"       ) ] = "lb";
  retVal[ i18n( "milliliter"  ) ] = "ml";
  retVal[ i18n( "cubic cm"    ) ] = "cb";
  retVal[ i18n( "centiliter"  ) ] = "cl";
  retVal[ i18n( "deciliter"   ) ] = "dl";
  retVal[ i18n( "liter"       ) ] = "l" ;
  retVal[ i18n( "milligram"   ) ] = "mg";
  retVal[ i18n( "centigram"   ) ] = "cg";
  retVal[ i18n( "decigram"    ) ] = "dg";
  retVal[ i18n( "gram"        ) ] = "g" ;
  retVal[ i18n( "kilogram"    ) ] = "kg";
  return retVal;
}

map< string, string > createInverseUnitMap(void)
{
  map< string, string > unitMap( createUnitMap() );

  map< string, string > retVal;

  for ( map< string, string >::const_iterator i = unitMap.begin();
        i != unitMap.end(); i++ )
    retVal.insert( make_pair( i->second, i->first ) );
  retVal[ "T" ] = (const char *)i18n( "tablespoon" );
  retVal[ "t" ] = (const char *)i18n( "teaspoon" );
  return retVal;
}


QStringList createUnitStringList(void)
{
  // Use code of 'createUnitMap'-method.
  map< string, string > unitMap( createUnitMap() );
  QStringList retVal;
  for ( map< string, string >::const_iterator i = unitMap.begin();
        i != unitMap.end(); i++ )
    retVal << (*i).first.c_str();
#ifndef NDEBUG
  cerr << retVal.size() << " units." << endl;
#endif
  return retVal;
}
