/* Copyright (C) 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <cassert>
#ifndef NDEBUG
#include <iostream>
#endif
#include <stdlib.h>
#include "ingredientViewItem.hpp"
#include "utils.hpp"

using namespace std;

IngredientViewItem::IngredientViewItem( QListViewItem *parent,
                                        const QString &_amount1,
                                        const QString &_amount2,
                                        const QString &_amount3,
                                        const QString &_unit,
                                        const QString &_name,
                                        const QString &_prep ):
  QListViewItem( parent, "", _unit, _name, _prep )
{
  if ( !_amount1.isEmpty() )
    setAmount( atof( _amount1 ) );
  else
    setAmount( atoi( _amount2 ), atoi( _amount3 ) );
}

IngredientViewItem::IngredientViewItem( QListViewItem *parent,
                                        QListViewItem *after,
                                        const QString &_amount1,
                                        const QString &_amount2,
                                        const QString &_amount3,
                                        const QString &_unit,
                                        const QString &_name,
                                        const QString &_prep ):
  QListViewItem( parent, after, "", _unit, _name, _prep )
{
  if ( !_amount1.isEmpty() )
    setAmount( atof( _amount1 ) );
  else
    setAmount( atoi( _amount2 ), atoi( _amount3 ) );
}

void IngredientViewItem::setAmount( double _amountDouble )
{
  assert( _amountDouble >= 0.0 );

  amountDouble = _amountDouble;
  amountNominator = 0;
  amountDenominator = 0;

  if ( amountDouble != 0.0 )
    setText( 0, QString( "%1" ).arg( amountDouble ) );
  else
    setText( 0, "" );
}

void IngredientViewItem::setAmount( int _amountNominator,
                                    int _amountDenominator )
{
  assert( _amountNominator >= 0 );
  assert( _amountDenominator >= 0 );

  amountDouble = 0.0;
  amountNominator = _amountNominator;
  amountDenominator = _amountDenominator;

  if ( amountDenominator == 0 ) amountDenominator = 1;

  if ( amountNominator > 0 ) {

    int greatestCommonDivisor = gcd( amountNominator, amountDenominator );
    amountNominator /= greatestCommonDivisor;
    amountDenominator /= greatestCommonDivisor;

    if ( amountDenominator > 1 ) {
      if ( amountNominator >= amountDenominator )
        setText( 0, QString( "%1 %2/%3" ).
                 arg( amountNominator / amountDenominator ).
                 arg( amountNominator % amountDenominator ).
                 arg( amountDenominator ) );
      else
        setText( 0, QString( "%1/%2" ).
                 arg( amountNominator ).
                 arg( amountDenominator ) );
    } else
      setText( 0, QString( "%1" ).arg( amountNominator ) );
  
  } else
    setText( 0, "" );
}

void IngredientViewItem::setFraction( bool _fraction )
{
  if ( _fraction != isFraction() ) {
    if ( _fraction ) {
      setAmount( (int)( amountDouble * 1000 ), 1000 );
    } else {
      assert( amountDenominator > 0 );
      setAmount( (double)amountNominator / amountDenominator );
    };
  };
}

int IngredientViewItem::getAmountNumber(void) const
{
  assert( amountDenominator > 0 );
  return amountNominator / amountDenominator;
}

int IngredientViewItem::getAmountNominator(void) const
{
  assert( amountDenominator > 0 );
  return amountNominator % amountDenominator;
}
