<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8"/>

  <xsl:template match="/cookml">
    <cookbook>
      <xsl:apply-templates select="recipe"/>
    </cookbook>
  </xsl:template>

  <xsl:template match="recipe">
    <recipe>
      <title><xsl:value-of select="head/@title"/></title>
      <categories>
        <xsl:for-each select="head/cat">
          <category><xsl:value-of select="."/></category>
        </xsl:for-each>
      </categories>
      <servings>
        <amount><xsl:value-of select="round(head/@servingqty)"/></amount>
        <unit><xsl:value-of select="head/@servingtype"/></unit>
      </servings>
      <ingredients>
        <xsl:for-each select="part">
          <xsl:if test="@title">
            <title><xsl:value-of select="@title"/></title>
          </xsl:if>
          <xsl:for-each select="ingredient">
            <ingredient>
              <xsl:if test="@qty">
                <amount><xsl:value-of select="@qty"/></amount>
              </xsl:if>
              <xsl:if test="@unit">
                <unit><xsl:value-of select="@unit"/></unit>
              </xsl:if>
              <name><xsl:value-of select="@item"/></name>
            </ingredient>
          </xsl:for-each>
        </xsl:for-each>
      </ingredients>
      <instructions>
        <xsl:for-each select="preparation/text|preparation/step">
          <section>
            <xsl:value-of select="."/>
          </section>          
        </xsl:for-each>
      </instructions>
    </recipe>
  </xsl:template>

</xsl:stylesheet>
