// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef MFIPANALYSE_H
#define MFIPANALYSE_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "analyse.h"

/** This simple analysis module count every mail from given ip adress.
  *@short Mail from ip analysis.
  *@author Tobias Erbsland
  */
class mfipAnalyse : public Analyse
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	/** Map for the analysis. */
	std::multimap<long, std::string> mailc_ip;

public:
	mfipAnalyse();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual void run( std::map<std::string, unity_t> * unity_map );
	virtual void print( void );
	virtual void free( void );

	virtual ~mfipAnalyse() { };
};

#endif
