//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2008 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#if !defined(_REMOTESETTINGS_H_)
#define _REMOTESETTINGS_H_

#include <exception>                    // per std::exception (Mr Hyde)
#include <vector>                       // per std::vector (Mr Hyde)
#include <algorithm>                    // per std::find_if (Mr Hyde)

#include <wx/config.h>			// to let wxWidgets choose a wxConfig class for your platform
#include <wx/confbase.h>		// base config class
#include <wx/fileconf.h>		// wxFileConfig class
#include <wx/string.h>		      // wxString
#include "Types.h"


class CMatchBannedModPredicate
{
	private:
		wxString m_modName;

	public:
		CMatchBannedModPredicate(const wxString& k) : m_modName(k) {};
		~CMatchBannedModPredicate() {};

		inline bool operator()(const wxString& toCheck) const
		{
			return (m_modName.Contains(toCheck));
		}
};


class CRemoteSettings {
	// member variables
	public:
		static const wxString ADUNANZA_CONF; // name of adunanza.conf file
			
		long          kadRepublishTimeK;
		long          kadRepublishTimeS;
		long          kadRepublishTimeN;

		long          kadIndexLifeK; // Mr Hyde per allineamento a eMule 3.15b74
		long          kadIndexLifeS; // Mr Hyde per allineamento a eMule 3.15b74

		uint32_t      kadTotalStoreKey;   // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h
		uint32_t      kadTotalStoreSrc;   // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h
		uint32_t      kadTotalStoreNotes; // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h

		long          kadTotalSearchFile;

		long          kadMaxSrcFile;
		long          kadMaxNotFile;

		double        kadFreshGuess_Tol;
		double        kadFreshGuess_Weight;
		long          kadFreshGuess_NoNorm;
		long          kadFreshGuess_LowNorm;

		long          maxSrc;
		long          maxSrcUdp;

		long          kadFindValue;
		long          kadStore;
		long          kadFindNode;

		long          kadReaskTime;
		long          kadPubTime;

		long          kadReaskIncs;

		long          mVer;

		unsigned char kadOpcode;
		unsigned char kadZOpcode;

		wxString      UpdateURL;

		std::vector<wxString> m_badMods; // Mr Hyde: lista stringhe per Mod di cui fare il ban
	private:
		time_t        nextUpdate;
		int           failCount;
		long          expireTime;
		long          recheckTime; 

		wxFileConfig* cfg;
		wxString      ConfigDir;

	public:
		CRemoteSettings();
		virtual ~CRemoteSettings();

		void AllocateAdunanzaConf(); // Mr Hyde

		// void ReadSettings(wxConfigBase* pBaseCfg);
		void ReadSettings(const wxConfigBase& baseCfg);
		void SaveSettings();

		void PrintAllValues();

		void SaveToFile();
		void CheckUpdate();
		void FileDownloadedCallback(int result);

		// Mr Hyde
		inline bool isBannedMod(const wxString& modName) const
		{
			/*
			std::vector<vxString> it;
			it = find_if(m_badsMod.begin(), m_badMods.end(), CMatchBannedModPredicate(modName));
			return (it != m_badMods.end());
			*/
			return (std::find_if(m_badMods.begin(), m_badMods.end(), CMatchBannedModPredicate(modName)) != m_badMods.end());
		}
};


#endif // _REMOTESETTINGS_H_

