//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2008 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#include <iostream>   // Mr Hyde
#include <exception>  // Mr Hyde
#include <vector>     // per std::vector (Mr Hyde)
#include <memory>     // per auto_ptr Mr Hyde
#include <wx/tokenzr.h> // Mr Hyde per wxStringTokenixer

#include "RemoteSettings.h"
#include <protocol/kad/Constants.h>
#include <protocol/ed2k/Constants.h>
#include <common/Macros.h>
#include <protocol/Protocols.h>
#include "InternalEvents.h"                // Needed for CMuleInternalEvent
#include "OtherFunctions.h" // needed for GetConfigDir()
#include "HTTPDownload.h"   // needed for CHTTPDownloader
#include <wx/filefn.h>
#include <wx/url.h>         // wxURL
#include <common/StringFunctions.h>
#include "AdunanzA.h"

#define RSEXPIRETIME HR2S(96)

#define RSRECHECKTIME HR2S(6)

#define FAILCHECKSTATIC 3

#define ADURM_TMPFILE "_tmp_adunanza.conf"

/* static*/ const wxString CRemoteSettings::ADUNANZA_CONF(wxT("adunanza.conf")); // name of adunanza.conf file

void CRemoteSettings::AllocateAdunanzaConf()
{
	wxString theAdunanzAConfigPath = ConfigDir + CRemoteSettings::ADUNANZA_CONF;



	if (cfg) delete cfg;

	cfg = 0;

	try {
		cfg = new wxFileConfig(wxEmptyString, wxEmptyString, theAdunanzAConfigPath );
	}
	catch (const std::bad_alloc& ba) {
		std::cerr << "(CRemoteSettings::AllocateAdunanzaConf) Failed to allocate AdunanzA config manager - " << ba.what() << std::endl;
	}
	catch (const std::exception& e) {
		std::cerr << "(CRemoteSettings::AllocateAdunanzaConf) Failed to allocate AdunanzA config manager (exception) - " << e.what() << std::endl;
	}
	catch (...) {
		std::cerr << "(CRemoteSettings::AllocateAdunanzaConf) Failed to allocate AdunanzA config manager (unknown)" << std::endl;
	}

}

CRemoteSettings::CRemoteSettings() :
	kadRepublishTimeK(KADEMLIAREPUBLISHTIMEK),
	kadRepublishTimeS(KADEMLIAREPUBLISHTIMES),
	kadRepublishTimeN(KADEMLIAREPUBLISHTIMEN),
	kadIndexLifeK(HR2S(96)), // Mr Hyde allineamento eMule AdunanzA 3.15b74
	kadIndexLifeS(HR2S(96)), // Mr Hyde allineamento eMule AdunanzA 3.15b74
	kadTotalStoreKey(KADEMLIATOTALSTOREKEY),
	kadTotalStoreSrc(KADEMLIATOTALSTORESRC),
	kadTotalStoreNotes(KADEMLIATOTALSTORENOTES),
	kadTotalSearchFile(KADEMLIATOTALFILE),
	kadMaxSrcFile(KADEMLIAMAXSOURCEPERFILE),
	kadMaxNotFile(KADEMLIAMAXNOTESPERFILE),
	kadFreshGuess_Tol(KADEMLIAFRESHGUESS_TOLERANCE),
	kadFreshGuess_Weight(KADEMLIAFRESHGUESS_WEIGHT),
	kadFreshGuess_NoNorm(KADEMLIAFRESHGUESS_NONORMSOURCES),
	kadFreshGuess_LowNorm(KADEMLIAFRESHGUESS_LOWNORMSOURCES),
	maxSrc(MAX_SOURCES_FILE_SOFT),
	maxSrcUdp(MAX_SOURCES_FILE_UDP),
	kadFindValue(KADEMLIA_FIND_VALUE),
	kadStore(KADEMLIA_STORE),
	kadFindNode(KADEMLIA_FIND_NODE),
	kadReaskTime(KADEMLIAREASKTIME),
	kadPubTime(KADEMLIAPUBLISHTIME),
	kadReaskIncs(7),
	mVer(0),
	kadOpcode(OP_KADEMLIAHEADER),
	kadZOpcode(OP_KADEMLIAPACKEDPROT),
	UpdateURL(wxT(ADURM_URL)),
	nextUpdate(0),
	failCount(0),
	expireTime(0),
	recheckTime(0),
	cfg(0)
{

	ConfigDir = GetConfigDir();
	
	AllocateAdunanzaConf();
	if (!cfg) {
		std::cerr << "AdunanzA config is NULL - cannot continue" << std::endl;
		return;
	}

	try
	{

		wxString nU;
		cfg->Read(wxT("/Adunanza/nextUpdate") , &nU, wxT("0"));
		nextUpdate = strtoul(unicode2char(nU.c_str()),NULL,10);
		cfg->Read(wxT("/Adunanza/failCount") , &failCount, failCount);

		//std::cout << "---------------- On init -----------------" << std::endl;
		//PrintAllValues();

		// ReadSettings(cfg); Mr Hyde
		ReadSettings(*cfg); // Mr Hyde
	}
	catch(const std::exception& e)
	{
		std::cerr << "(CRemoteSettings) Got exception: " << e.what() << std::endl;
	}
	catch(...)
	{
		std::cerr << "(CRemoteSettings) Got unidentified exception" << std::endl;
	}

	if ( nextUpdate > time(NULL) + (time_t)expireTime )
		nextUpdate = time(NULL) + (time_t)expireTime ;

	// std::cout << "---------------- After reading -----------------" << std::endl;
	//PrintAllValues();
}

CRemoteSettings::~CRemoteSettings() {
	// std::cout << "---------------- On close -----------------" << std::endl;
	//PrintAllValues();

	SaveSettings();
	delete cfg;
	cfg = NULL; // Mr Hyde
}

void CRemoteSettings::PrintAllValues() {
#if ADU_BETA_MAJ > 0
	std::cout << "kadRepublishTimeK:     " << kadRepublishTimeK << '\n'
	          << "kadRepublishTimeS:     " << kadRepublishTimeS << '\n'
		  << "kadRepublishTimeN:     " << kadRepublishTimeN << '\n'
		  << "kadIndexLifeK:         " << kadIndexLifeK << '\n' // Mr Hyde all. eMule Adu 3.15b74
		  << "kadIndexLifeS:         " << kadIndexLifeS << '\n' // Mr Hyde all. eMule Adu 3.15b74
	          << "kadTotalStoreKey:      " << kadTotalStoreKey << '\n'
		  << "kadTotalStoreSrc:      " << kadTotalStoreSrc << '\n'
		  << "kadTotalStoreNotes:    " << kadTotalStoreNotes << '\n'
	          << "kadTotalSearchFile:    " << kadTotalSearchFile << '\n'
	          << "kadMaxSrcFile:         " << kadMaxSrcFile << '\n'
		  << "kadMaxNotFile:         " << kadMaxNotFile << '\n'
	          << "kadFreshGuess_Tol:     " << kadFreshGuess_Tol << '\n'
		  << "kadFreshGuess_Weight:  " << kadFreshGuess_Weight << '\n'
		  << "kadFreshGuess_LowNorm: " << kadFreshGuess_LowNorm << '\n'
		  << "kadFreshGuess_NoNorm: " << kadFreshGuess_NoNorm << '\n'
	          << "maxSrc:               " << maxSrc << '\n'
		  << "maxSrcUdp:            " << maxSrcUdp << '\n'
	          << "kadFindValue:         " << kadFindValue << '\n'
		  << "kadStore:             " << kadStore << '\n'
		  << "kadFindNode:          " << kadFindNode << '\n'
	          << "kadReaskTime:         " << kadReaskTime << '\n'
		  << "kadReaskIncs:         " << kadReaskIncs << '\n'
		  << "kadPubTime:           " << kadPubTime << '\n'
		  << "mVer:                 " << mVer << '\n'
	          << "opcodes Norm:         " << std::hex << (unsigned short) kadOpcode << '\n'
		  << "Zip:                  " << std::hex << (unsigned short) kadZOpcode << std::dec << '\n'
	          << "- nextUpdate in:      " << nextUpdate-time(NULL) << " seconds\n"
	          << "- expireTime:         " << expireTime << '\n'
		  << "- recheckTime:        " << recheckTime << '\n'
		  << "failCount:            " << failCount << '\n'
	          << "updating from:        " << (const char*)unicode2char(UpdateURL) << '\n';

		// Mr Hyde allineamento eMule 3.15 (mods da bannare)
		if (m_badMods.empty())
			std::cout << "No mods to ban";		
		else {
			std::cout << "Mods to ban: \n{";
			for (std::vector<wxString>::const_iterator it = m_badMods.begin();
					it != m_badMods.end();
					++it) {
				std::cout << "\n\t" << (const char*) unicode2char(*it);
			}
			std::cout << "\n}";
		}
		std::cout << std::endl;
#endif
}


void CRemoteSettings::SaveToFile() {
	SaveSettings();
	AllocateAdunanzaConf();
}

void CRemoteSettings::ReadSettings(const wxConfigBase& docfg) {
	docfg.Read(wxT("/Adunanza/expireTime") , &expireTime, expireTime);
	docfg.Read(wxT("/Adunanza/recheckTime") , &recheckTime, recheckTime);
	docfg.Read(wxT("/Adunanza/UpdateURL") , &UpdateURL, UpdateURL);

	if (expireTime > RSEXPIRETIME)
		expireTime = RSEXPIRETIME;

	if (recheckTime > RSRECHECKTIME)
		recheckTime = RSRECHECKTIME;

	docfg.Read(wxT("/Adunanza/kadRepublishTimeK") , &kadRepublishTimeK, kadRepublishTimeK);
	docfg.Read(wxT("/Adunanza/kadRepublishTimeS") , &kadRepublishTimeS, kadRepublishTimeS);
	docfg.Read(wxT("/Adunanza/kadRepublishTimeN") , &kadRepublishTimeN, kadRepublishTimeN);

	docfg.Read(wxT("/Adunanza/kadIndexLifeK") , &kadIndexLifeK, kadIndexLifeK); // Mr Hyde all emule Adu 3.15b74
	docfg.Read(wxT("/Adunanza/kadIndexLifeS") , &kadIndexLifeS, kadIndexLifeS); // Mr Hyde all emule Adu 3.15b74

	long long_kadTotalStoreKey   = 0;
	long long_kadTotalStoreSrc   = 0;
	long long_kadTotalStoreNotes = 0;
	docfg.Read(wxT("/Adunanza/kadTotalStoreKey") , &long_kadTotalStoreKey, long_kadTotalStoreKey);
	docfg.Read(wxT("/Adunanza/kadTotalStoreSrc") , &long_kadTotalStoreSrc, long_kadTotalStoreSrc);
	docfg.Read(wxT("/Adunanza/kadTotalStoreNotes") , &long_kadTotalStoreNotes, long_kadTotalStoreNotes);
	kadTotalStoreKey   = static_cast<uint32_t>(long_kadTotalStoreKey);
	kadTotalStoreSrc   = static_cast<uint32_t>(long_kadTotalStoreSrc);
	kadTotalStoreNotes = static_cast<uint32_t>(long_kadTotalStoreNotes);

	docfg.Read(wxT("/Adunanza/kadTotalSearchFile") , &kadTotalSearchFile, kadTotalSearchFile);

	docfg.Read(wxT("/Adunanza/kadMaxSrcFile") , &kadMaxSrcFile, kadMaxSrcFile);
	docfg.Read(wxT("/Adunanza/kadMaxNotFile") , &kadMaxNotFile, kadMaxNotFile);

	kadFreshGuess_Tol = docfg.Read(wxT("/Adunanza/kadFreshGuess_Tol") , (long)(kadFreshGuess_Tol * 10000)) / 10000.f;
	kadFreshGuess_Weight = docfg.Read(wxT("/Adunanza/kadFreshGuess_Weight") , (long)(kadFreshGuess_Weight * 10000)) / 10000.f;
	docfg.Read(wxT("/Adunanza/kadFreshGuess_LowNorm") , &kadFreshGuess_LowNorm, kadFreshGuess_LowNorm);
	docfg.Read(wxT("/Adunanza/kadFreshGuess_NoNorm") , &kadFreshGuess_NoNorm, kadFreshGuess_NoNorm);

	docfg.Read(wxT("/Adunanza/maxSrc") , &maxSrc, maxSrc);
	docfg.Read(wxT("/Adunanza/maxSrcUdp") , &maxSrcUdp, maxSrcUdp);

	docfg.Read(wxT("/Adunanza/kadFindValue") , &kadFindValue, kadFindValue);
	docfg.Read(wxT("/Adunanza/kadStore") , &kadStore, kadStore);
	docfg.Read(wxT("/Adunanza/kadFindNode") , &kadFindNode, kadFindNode);

	docfg.Read(wxT("/Adunanza/kadReaskTime") , &kadReaskTime, kadReaskTime);
	docfg.Read(wxT("/Adunanza/kadReaskIncs") , &kadReaskIncs, kadReaskIncs);
	docfg.Read(wxT("/Adunanza/kadPubTime") , &kadPubTime, kadPubTime);
	docfg.Read(wxT("/Adunanza/mVer") , &mVer, mVer);

	kadOpcode = (unsigned char)docfg.Read(wxT("/Adunanza/kadOpcode") , (long)kadOpcode);
	kadZOpcode = (unsigned char)docfg.Read(wxT("/Adunanza/kadZOpcode") , (long)kadZOpcode);

	// Mr Hyde:
	// Per allineamento a 3.15
	wxString allBadMods;
	docfg.Read(wxT("/Adunanza/modstringban") , &allBadMods, allBadMods);
	m_badMods.clear();
	if (!allBadMods.IsEmpty()) {
		// l'elenco delle mod e' in un'unica stringa,
		// le mod sono separatre dal carattere ";" (punto e virgola)
		wxString modName;
		wxStringTokenizer tkz(allBadMods, wxT(";"));
		while ( tkz.HasMoreTokens() )
		{
			wxString token = tkz.GetNextToken();
			m_badMods.push_back(token);
		}
	}
	
}

void CRemoteSettings::SaveSettings() {
	if (!cfg) return; // Mr Hyde
	cfg->Write(wxT("/Adunanza/nextUpdate") , wxString::Format(wxT("%ul"),nextUpdate));
	cfg->Write(wxT("/Adunanza/failCount") , failCount);
	cfg->Write(wxT("/Adunanza/UpdateURL") , UpdateURL);
	cfg->Write(wxT("/Adunanza/expireTime") , expireTime);
	cfg->Write(wxT("/Adunanza/recheckTime") , recheckTime);

	cfg->Write(wxT("/Adunanza/kadRepublishTimeK") , kadRepublishTimeK);
	cfg->Write(wxT("/Adunanza/kadRepublishTimeS") , kadRepublishTimeS);
	cfg->Write(wxT("/Adunanza/kadRepublishTimeN") , kadRepublishTimeN);

	cfg->Write(wxT("/Adunanza/kadIndexLifeK") , kadIndexLifeK); // Mr Hyde all emule Adu 3.15b74
	cfg->Write(wxT("/Adunanza/kadIndexLifeS") , kadIndexLifeS); // Mr Hyde all emule Adu 3.15b74

	long long_kadTotalStoreKey   = static_cast<long>(kadTotalStoreKey);
	long long_kadTotalStoreSrc   = static_cast<long>(kadTotalStoreSrc);
	long long_kadTotalStoreNotes = static_cast<long>(kadTotalStoreNotes);
	cfg->Write(wxT("/Adunanza/kadTotalStoreKey") ,   long_kadTotalStoreKey);
	cfg->Write(wxT("/Adunanza/kadTotalStoreSrc") ,   long_kadTotalStoreSrc);
	cfg->Write(wxT("/Adunanza/kadTotalStoreNotes") , long_kadTotalStoreNotes);

	cfg->Write(wxT("/Adunanza/kadTotalSearchFile") , kadTotalSearchFile);

	cfg->Write(wxT("/Adunanza/kadMaxSrcFile") , kadMaxSrcFile);
	cfg->Write(wxT("/Adunanza/kadMaxNotFile") , kadMaxNotFile);

	cfg->Write(wxT("/Adunanza/kadFreshGuess_Tol") , (long)(kadFreshGuess_Tol * 10000));
	cfg->Write(wxT("/Adunanza/kadFreshGuess_Weight") , (long)(kadFreshGuess_Weight * 10000));
	cfg->Write(wxT("/Adunanza/kadFreshGuess_LowNorm") , kadFreshGuess_LowNorm);
	cfg->Write(wxT("/Adunanza/kadFreshGuess_NoNorm") , kadFreshGuess_NoNorm);

	cfg->Write(wxT("/Adunanza/maxSrc") , maxSrc);
	cfg->Write(wxT("/Adunanza/maxSrcUdp") , maxSrcUdp);

	cfg->Write(wxT("/Adunanza/kadFindValue") , kadFindValue);
	cfg->Write(wxT("/Adunanza/kadStore") , kadStore);
	cfg->Write(wxT("/Adunanza/kadFindNode") , kadFindNode);

	cfg->Write(wxT("/Adunanza/kadReaskTime") , kadReaskTime);
	cfg->Write(wxT("/Adunanza/kadReaskIncs") , kadReaskIncs);
	cfg->Write(wxT("/Adunanza/kadPubTime") , kadPubTime);
	cfg->Write(wxT("/Adunanza/mVer") , mVer);

	cfg->Write(wxT("/Adunanza/kadOpcode"), (long)kadOpcode);
	cfg->Write(wxT("/Adunanza/kadZOpcode"), (long)kadZOpcode);

	if (!m_badMods.empty())
	{
		wxString tmpBadMods;
		unsigned int i;
		for (i = 0; i < (m_badMods.size() - 1); i++)
		{
			tmpBadMods << m_badMods[i] << wxChar(';');
		}
		tmpBadMods << m_badMods[i];
		cfg->Write(wxT("/Adunanza/modstringban") , tmpBadMods);
	}

}

void CRemoteSettings::CheckUpdate() {
	if (time(NULL) < (time_t)nextUpdate)
		return;

	//printf("---------------- Before update -----------------\n");
	//PrintAllValues();

	wxString strURL(UpdateURL);

	if (wxURL(strURL).GetError() == wxURL_NOERR) { // Mr Hyde: validate URL
		wxString tmpFile(ConfigDir + wxT(ADURM_TMPFILE));
		if (wxFileExists(tmpFile)) {
			wxRemoveFile(tmpFile);
		}

		try {
			CHTTPDownloadThread *downloader = new CHTTPDownloadThread(strURL, tmpFile, HTTP_AdunanzaConf);
			downloader->Create();
			downloader->Run();
		}
		catch (...) {
			std::cerr << "(CRemoteSettings::CheckUpdate) Got exception! " << std::endl;
		}
	}
}

void CRemoteSettings::FileDownloadedCallback(int result) {
	//printf("---------------- Before update (2) ----------------- result: %d\n",result);
	//PrintAllValues();

	if (result == -1) {
		double scaled = rand() / (RAND_MAX + 1.0);
		nextUpdate = time(NULL) + (time_t)recheckTime + (time_t)((recheckTime + 1) * scaled);
		failCount++;
		if (failCount > FAILCHECKSTATIC) {
			UpdateURL = wxT(ADURM_URL);
			SaveSettings();
		}
		return;
	}

	wxString tmpFile(ConfigDir + wxT(ADURM_TMPFILE));
	if (!wxFileExists(tmpFile))
		return;

	try {

		// wxFileConfig *tmpcfg = new wxFileConfig(wxEmptyString, wxEmptyString, tmpFile); // Mr Hyde - uso auto_ptr
		std::auto_ptr<wxFileConfig> ptmpcfg(new wxFileConfig(wxEmptyString, wxEmptyString, tmpFile));

		ReadSettings(*ptmpcfg);
		// delete tmpcfg; // Mr Hyde: uso auto_ptr

		wxRemoveFile(tmpFile);

		SaveToFile();
	}
	catch(...)
	{
		std::cerr << "Something of wrong in CRemoteSettings::FileDownloadedCallback" << std::endl;
	}

	nextUpdate = time(NULL) + (time_t)expireTime;
	failCount = 0;

	std::cout << "---------------- After update -----------------" << std::endl;
	PrintAllValues();
}

