/* mapping table of MathML elements */
#include "MathML.h"
#include "MathMLentities.h"
static ElemMapping    MathMLElemMappingTable[] =
{
   /* This table MUST be in alphabetical order and in lower case */
   {"annotation", SPACE, MathML_EL_ANNOTATION, L_MathMLValue, TRUE},
   {"annotation-xml", SPACE, MathML_EL_ANNOTATION_XML, L_MathMLValue, TRUE},
   {"c", SPACE, MathML_EL_TEXT_UNIT, L_MathMLValue, TRUE},
   {"cdata", SPACE, MathML_EL_CDATA, L_OtherValue, FALSE},
   {"cdata_line", SPACE, MathML_EL_CDATA_line, L_OtherValue, FALSE},
   {"doctype", SPACE, MathML_EL_DOCTYPE, L_OtherValue, FALSE},
   {"doctype_line", SPACE, MathML_EL_DOCTYPE_line, L_OtherValue, FALSE},
   {"maligngroup", 'E', MathML_EL_MALIGNGROUP, L_MathMLValue, FALSE},
   {"malignmark", 'E', MathML_EL_MALIGNMARK, L_MathMLValue, FALSE},
   {"math", SPACE, MathML_EL_MathML, L_MathMLValue, TRUE},
   {"menclose", SPACE, MathML_EL_MENCLOSE, L_MathMLValue, FALSE},
   {"merror", SPACE, MathML_EL_MERROR, L_MathMLValue, FALSE},
   {"mf", SPACE, MathML_EL_MF, L_MathMLValue, FALSE},  /* for compatibility with an old version of MathML: WD-math-970704 */
   {"mfenced", SPACE, MathML_EL_MFENCED, L_MathMLValue, FALSE},
   {"mfrac", SPACE, MathML_EL_MFRAC, L_MathMLValue, FALSE},
   {"mglyph", 'E', MathML_EL_MGLYPH, L_MathMLValue, FALSE},
   {"mi", SPACE, MathML_EL_MI, L_MathMLValue, FALSE},
   {"mlabeledtr", SPACE, MathML_EL_MLABELEDTR, L_MathMLValue, FALSE},
   {"mmultiscripts", SPACE, MathML_EL_MMULTISCRIPTS, L_MathMLValue, FALSE},
   {"mn", SPACE, MathML_EL_MN, L_MathMLValue, FALSE},
   {"mo", SPACE, MathML_EL_MO, L_MathMLValue, FALSE},
   {"mover", SPACE, MathML_EL_MOVER, L_MathMLValue, FALSE},
   {"mpadded", SPACE, MathML_EL_MPADDED, L_MathMLValue, FALSE},
   {"mphantom", SPACE, MathML_EL_MPHANTOM, L_MathMLValue, FALSE},
   {"mprescripts", SPACE, MathML_EL_PrescriptPairs, L_MathMLValue, FALSE},
   {"mroot", SPACE, MathML_EL_MROOT, L_MathMLValue, FALSE},
   {"mrow", SPACE, MathML_EL_MROW, L_MathMLValue, FALSE},
   {"ms", SPACE, MathML_EL_MS, L_MathMLValue, FALSE},
   {"mspace", 'E', MathML_EL_MSPACE, L_MathMLValue, FALSE},
   {"msqrt", SPACE, MathML_EL_MSQRT, L_MathMLValue, FALSE},
   {"mstyle", SPACE, MathML_EL_MSTYLE, L_MathMLValue, FALSE},
   {"msub", SPACE, MathML_EL_MSUB, L_MathMLValue, FALSE},
   {"msubsup", SPACE, MathML_EL_MSUBSUP, L_MathMLValue, FALSE},
   {"msup", SPACE, MathML_EL_MSUP, L_MathMLValue, FALSE},
   {"mtable", SPACE, MathML_EL_MTABLE, L_MathMLValue, FALSE},
   {"mtd", SPACE, MathML_EL_MTD, L_MathMLValue, FALSE},
   {"mtext", SPACE, MathML_EL_MTEXT, L_MathMLValue, FALSE},
   {"mtr", SPACE, MathML_EL_MTR, L_MathMLValue, FALSE},
   {"munder", SPACE, MathML_EL_MUNDER, L_MathMLValue, FALSE},
   {"munderover", SPACE, MathML_EL_MUNDEROVER, L_MathMLValue, FALSE},
   {"none", SPACE, MathML_EL_Construct, L_MathMLValue, FALSE},
   {"semantics", SPACE, MathML_EL_SEMANTICS, L_MathMLValue, FALSE},
   {"xmlcomment", SPACE, MathML_EL_XMLcomment, L_OtherValue, FALSE},
   {"xmlcomment_line", SPACE, MathML_EL_XMLcomment_line, L_OtherValue, FALSE},
   {"xmlpi", SPACE, MathML_EL_XMLPI, L_OtherValue, FALSE},
   {"xmlpi_line", SPACE, MathML_EL_XMLPI_line, L_OtherValue, FALSE},
   {"", SPACE, 0, L_MathMLValue, FALSE}	 /* Last entry. Mandatory */
};

static AttributeMapping MathMLAttributeMappingTable[] =
{
   /* The first entry MUST be unknown_attr */
   /* The rest of this table MUST be in alphabetical order */
   {"unknown_attr", "", 'A', MathML_ATTR_Unknown_attribute, L_MathMLValue},

   {"accent", "", 'A', MathML_ATTR_accent, L_MathMLValue},
   {"accentunder", "", 'A', MathML_ATTR_accentunder, L_MathMLValue},
   {"actiontype", "", 'A', MathML_ATTR_actiontype, L_MathMLValue},
   {"align", "", 'A', MathML_ATTR_align, L_MathMLValue},
   {"alignmentscope", "", 'A', MathML_ATTR_alignmentscope, L_MathMLValue},
   {"alt", "", 'A', MathML_ATTR_alt, L_MathMLValue},
   {"altimg", "", 'A', MathML_ATTR_altimg, L_MathMLValue},
   {"alttext", "", 'A', MathML_ATTR_alttext, L_MathMLValue},
   {"background", "", 'A', MathML_ATTR_background_, L_MathMLValue},
   {"bevelled", "", 'A', MathML_ATTR_bevelled, L_MathMLValue},
   {"class", "", 'A', MathML_ATTR_class, L_MathMLValue},
   {"close", "", 'A', MathML_ATTR_close, L_MathMLValue},
   {"columnalign", "mtd", 'A', MathML_ATTR_columnalign_mtd, L_MathMLValue},
   {"columnalign", "", 'A', MathML_ATTR_columnalign, L_MathMLValue},
   {"columnlines", "", 'A', MathML_ATTR_columnlines, L_MathMLValue},
   {"columnspacing", "", 'A', MathML_ATTR_columnspacing, L_MathMLValue},
   {"columnspan", "", 'A', MathML_ATTR_columnspan, L_MathMLValue},
   {"columnwidth", "", 'A', MathML_ATTR_columnwidth, L_MathMLValue},
   {"color", "", 'A', MathML_ATTR_color, L_MathMLValue},
   {"definitionURL", "", 'A', MathML_ATTR_definitionURL, L_MathMLValue},
   {"denomalign", "", 'A', MathML_ATTR_denomalign, L_MathMLValue},
   {"depth", "", 'A', MathML_ATTR_depth_, L_MathMLValue},
   {"display", "", 'A', MathML_ATTR_display_, L_MathMLValue},
   {"displaystyle", "", 'A', MathML_ATTR_displaystyle, L_MathMLValue},
   {"edge", "", 'A', MathML_ATTR_edge, L_MathMLValue},
   {"encoding", "", 'A', MathML_ATTR_encoding, L_MathMLValue},
   {"equalcolumns", "", 'A', MathML_ATTR_equalcolumns, L_MathMLValue},
   {"equalrows", "", 'A', MathML_ATTR_equalrows, L_MathMLValue},
   {"fence", "", 'A', MathML_ATTR_fence, L_MathMLValue},
   {"fontfamily", "", 'A', MathML_ATTR_fontfamily, L_MathMLValue},
   {"fontstyle", "", 'A', MathML_ATTR_fontstyle, L_MathMLValue},
   {"fontsize", "", 'A', MathML_ATTR_fontsize, L_MathMLValue},
   {"fontweight", "", 'A', MathML_ATTR_fontweight, L_MathMLValue},
   {"form", "", 'A', MathML_ATTR_form, L_MathMLValue},
   {"frame", "", 'A', MathML_ATTR_frame, L_MathMLValue},
   {"framespacing", "", 'A', MathML_ATTR_framespacing, L_MathMLValue},
   {"groupalign", "maligngroup", 'A', MathML_ATTR_groupalign_malgr, L_MathMLValue},
   {"groupalign", "", 'A', MathML_ATTR_groupalign, L_MathMLValue},
   {"height", "", 'A', MathML_ATTR_height_, L_MathMLValue},
   {"id", "", 'A', MathML_ATTR_id, L_MathMLValue},
   {"index", "", 'A', MathML_ATTR_index, L_MathMLValue},
   {"lang", "", 'A', MathML_ATTR_Language, L_MathMLValue},
   {"largeop", "", 'A', MathML_ATTR_largeop, L_MathMLValue},
   {"linebreak", "", 'A', MathML_ATTR_linebreak_, L_MathMLValue},
   {"linethickness", "", 'A', MathML_ATTR_linethickness, L_MathMLValue},
   {"lquote", "", 'A', MathML_ATTR_lquote, L_MathMLValue},
   {"lspace", "", 'A', MathML_ATTR_lspace, L_MathMLValue},
   {"macros", "", 'A', MathML_ATTR_macros, L_MathMLValue},
   {"mathbackground", "", 'A', MathML_ATTR_mathbackground, L_MathMLValue},
   {"mathcolor", "", 'A', MathML_ATTR_mathcolor, L_MathMLValue},
   {"mathsize", "", 'A', MathML_ATTR_mathsize, L_MathMLValue},
   {"mathvariant", "", 'A', MathML_ATTR_mathvariant, L_MathMLValue},
   {"maxsize", "", 'A', MathML_ATTR_maxsize, L_MathMLValue},
   {"minlabelspacing", "", 'A', MathML_ATTR_minlabelspacing, L_MathMLValue},
   {"minsize", "", 'A', MathML_ATTR_minsize, L_MathMLValue},
   {"mode", "", 'A', MathML_ATTR_display_, L_MathMLValue},
   {"movablelimits", "", 'A', MathML_ATTR_movablelimits, L_MathMLValue},
   {"notation", "", 'A', MathML_ATTR_notation, L_MathMLValue},
   {"numalign", "", 'A', MathML_ATTR_numalign, L_MathMLValue},
   {"open", "", 'A', MathML_ATTR_open, L_MathMLValue},
   {"other", "", 'A', MathML_ATTR_other, L_MathMLValue},
   {"overflow", "", 'A', MathML_ATTR_overflow, L_MathMLValue},
   {"rowalign", "mtr", 'A', MathML_ATTR_rowalign_mtr, L_MathMLValue},
   {"rowalign", "mlabeledtr", 'A', MathML_ATTR_rowalign_mtr, L_MathMLValue},
   {"rowalign", "mtd", 'A', MathML_ATTR_rowalign_mtr, L_MathMLValue},
   {"rowalign", "", 'A', MathML_ATTR_rowalign, L_MathMLValue},
   {"rowlines", "", 'A', MathML_ATTR_rowlines, L_MathMLValue},
   {"rowspacing", "", 'A', MathML_ATTR_rowspacing, L_MathMLValue},
   {"rowspan", "", 'A', MathML_ATTR_rowspan_, L_MathMLValue},
   {"rquote", "", 'A', MathML_ATTR_rquote, L_MathMLValue},
   {"rspace", "", 'A', MathML_ATTR_rspace, L_MathMLValue},
   {"scriptlevel", "", 'A', MathML_ATTR_scriptlevel, L_MathMLValue},
   {"scriptminsize", "", 'A', MathML_ATTR_scriptminsize, L_MathMLValue},
   {"scriptsizemultiplier", "", 'A', MathML_ATTR_scriptsizemultiplier, L_MathMLValue},
   {"selection", "", 'A', MathML_ATTR_selection, L_MathMLValue},
   {"separator", "", 'A', MathML_ATTR_separator, L_MathMLValue},
   {"separators", "", 'A', MathML_ATTR_separators, L_MathMLValue},
   {"side", "", 'A', MathML_ATTR_side, L_MathMLValue},
   {"stretchy", "", 'A', MathML_ATTR_stretchy, L_MathMLValue},
   {"style", "", 'A', MathML_ATTR_style_, L_MathMLValue},
   {"subscriptshift", "", 'A', MathML_ATTR_subscriptshift, L_MathMLValue},
   {"superscriptshift", "", 'A', MathML_ATTR_superscriptshift, L_MathMLValue},
   {"symmetric", "", 'A', MathML_ATTR_symmetric, L_MathMLValue},
   {"width", "", 'A', MathML_ATTR_width_, L_MathMLValue},
   {"xml:id", "", 'A', MathML_ATTR_xmlid, L_MathMLValue},
   {"xml:space", "", 'A', MathML_ATTR_xml_space, L_MathMLValue},
   {"xref", "", 'A', MathML_ATTR_xref, L_MathMLValue},
   {"zzghost", "", 'A', MathML_ATTR_Ghost_restruct, L_MathMLValue},

   {"", "", EOS, 0, L_MathMLValue}		/* Last entry. Mandatory */
};


/* mapping table of attribute values */
static AttrValueMapping MathMLAttrValueMappingTable[] =
{
 {MathML_ATTR_accent, "true", MathML_ATTR_accent_VAL_true},
 {MathML_ATTR_accent, "false", MathML_ATTR_accent_VAL_false},

 {MathML_ATTR_accentunder, "true", MathML_ATTR_accentunder_VAL_true},
 {MathML_ATTR_accentunder, "false", MathML_ATTR_accentunder_VAL_false},

 {MathML_ATTR_align, "top", MathML_ATTR_align_VAL_top_},
 {MathML_ATTR_align, "bottom", MathML_ATTR_align_VAL_bottom_},
 {MathML_ATTR_align, "center", MathML_ATTR_align_VAL_center},
 {MathML_ATTR_align, "baseline", MathML_ATTR_align_VAL_baseline},
 {MathML_ATTR_align, "axis", MathML_ATTR_align_VAL_axis},

 {MathML_ATTR_bevelled, "true", MathML_ATTR_bevelled_VAL_true},
 {MathML_ATTR_bevelled, "false", MathML_ATTR_bevelled_VAL_false},

 {MathML_ATTR_columnalign_mtd, "center", MathML_ATTR_columnalign_mtd_VAL_center_},
 {MathML_ATTR_columnalign_mtd, "left", MathML_ATTR_columnalign_mtd_VAL_left_},
 {MathML_ATTR_columnalign_mtd, "right", MathML_ATTR_columnalign_mtd_VAL_right_},

 {MathML_ATTR_denomalign, "center", MathML_ATTR_denomalign_VAL_center_},
 {MathML_ATTR_denomalign, "left", MathML_ATTR_denomalign_VAL_left_},
 {MathML_ATTR_denomalign, "right", MathML_ATTR_denomalign_VAL_right_},

 {MathML_ATTR_display_, "block", MathML_ATTR_display__VAL_block_},
 {MathML_ATTR_display_, "display", MathML_ATTR_display__VAL_block_},
 {MathML_ATTR_display_, "inline", MathML_ATTR_display__VAL_inline_},

 {MathML_ATTR_displaystyle, "true", MathML_ATTR_displaystyle_VAL_true},
 {MathML_ATTR_displaystyle, "false", MathML_ATTR_displaystyle_VAL_false},

 {MathML_ATTR_edge, "left", MathML_ATTR_edge_VAL_left_},
 {MathML_ATTR_edge, "right", MathML_ATTR_edge_VAL_right_},

 {MathML_ATTR_equalcolumns, "true", MathML_ATTR_equalcolumns_VAL_true},
 {MathML_ATTR_equalcolumns, "false", MathML_ATTR_equalcolumns_VAL_false},

 {MathML_ATTR_equalrows, "true", MathML_ATTR_equalrows_VAL_true},
 {MathML_ATTR_equalrows, "false", MathML_ATTR_equalrows_VAL_false},

 {MathML_ATTR_fence, "true", MathML_ATTR_fence_VAL_true},
 {MathML_ATTR_fence, "false", MathML_ATTR_fence_VAL_false},

 {MathML_ATTR_fontstyle, "italic", MathML_ATTR_fontstyle_VAL_italic},
 {MathML_ATTR_fontstyle, "normal", MathML_ATTR_fontstyle_VAL_normal_},

 {MathML_ATTR_fontweight, "normal", MathML_ATTR_fontweight_VAL_normal_},
 {MathML_ATTR_fontweight, "bold", MathML_ATTR_fontweight_VAL_bold_},

 {MathML_ATTR_form, "prefix", MathML_ATTR_form_VAL_prefix},
 {MathML_ATTR_form, "infix", MathML_ATTR_form_VAL_infix},
 {MathML_ATTR_form, "postfix", MathML_ATTR_form_VAL_postfix},

 {MathML_ATTR_frame, "none", MathML_ATTR_frame_VAL_none_},
 {MathML_ATTR_frame, "solid", MathML_ATTR_frame_VAL_solid_},
 {MathML_ATTR_frame, "dashed", MathML_ATTR_frame_VAL_dashed_},

 {MathML_ATTR_groupalign_malgr, "left", MathML_ATTR_groupalign_malgr_VAL_left_},
 {MathML_ATTR_groupalign_malgr, "center", MathML_ATTR_groupalign_malgr_VAL_center_},
 {MathML_ATTR_groupalign_malgr, "right", MathML_ATTR_groupalign_malgr_VAL_right_},
 {MathML_ATTR_groupalign_malgr, "decimalpoint", MathML_ATTR_groupalign_malgr_VAL_decimalpoint},

 {MathML_ATTR_largeop, "true", MathML_ATTR_largeop_VAL_true},
 {MathML_ATTR_largeop, "false", MathML_ATTR_largeop_VAL_false},

 {MathML_ATTR_linebreak_, "auto", MathML_ATTR_linebreak__VAL_auto_},
 {MathML_ATTR_linebreak_, "newline", MathML_ATTR_linebreak__VAL_newline},
 {MathML_ATTR_linebreak_, "indentingnewline", MathML_ATTR_linebreak__VAL_indentingnewline},
 {MathML_ATTR_linebreak_, "nobreak", MathML_ATTR_linebreak__VAL_nobreak_},
 {MathML_ATTR_linebreak_, "goodbreak", MathML_ATTR_linebreak__VAL_goodbreak},
 {MathML_ATTR_linebreak_, "badbreak", MathML_ATTR_linebreak__VAL_badbreak},

 {MathML_ATTR_mathvariant, "normal", MathML_ATTR_mathvariant_VAL_normal_},
 {MathML_ATTR_mathvariant, "bold", MathML_ATTR_mathvariant_VAL_bold_},
 {MathML_ATTR_mathvariant, "italic", MathML_ATTR_mathvariant_VAL_italic},
 {MathML_ATTR_mathvariant, "bold-italic", MathML_ATTR_mathvariant_VAL_bold_italic},
 {MathML_ATTR_mathvariant, "double-struck", MathML_ATTR_mathvariant_VAL_double_struck},
 {MathML_ATTR_mathvariant, "bold-fraktur", MathML_ATTR_mathvariant_VAL_bold_fraktur},
 {MathML_ATTR_mathvariant, "script", MathML_ATTR_mathvariant_VAL_script_},
 {MathML_ATTR_mathvariant, "bold-script", MathML_ATTR_mathvariant_VAL_bold_script},
 {MathML_ATTR_mathvariant, "fraktur", MathML_ATTR_mathvariant_VAL_fraktur_},
 {MathML_ATTR_mathvariant, "sans-serif", MathML_ATTR_mathvariant_VAL_sans_serif},
 {MathML_ATTR_mathvariant, "bold-sans-serif", MathML_ATTR_mathvariant_VAL_bold_sans_serif},
 {MathML_ATTR_mathvariant, "sans-serif-italic", MathML_ATTR_mathvariant_VAL_sans_serif_italic},
 {MathML_ATTR_mathvariant, "sans-serif-bold-italic", MathML_ATTR_mathvariant_VAL_sans_serif_bold_italic},
 {MathML_ATTR_mathvariant, "monospace", MathML_ATTR_mathvariant_VAL_monospace},

 {MathML_ATTR_movablelimits, "true", MathML_ATTR_movablelimits_VAL_true},
 {MathML_ATTR_movablelimits, "false", MathML_ATTR_movablelimits_VAL_false},

 {MathML_ATTR_notation, "longdiv", MathML_ATTR_notation_VAL_longdiv},
 {MathML_ATTR_notation, "actuarial", MathML_ATTR_notation_VAL_actuarial},
 {MathML_ATTR_notation, "radical", MathML_ATTR_notation_VAL_radical},

 {MathML_ATTR_numalign, "center", MathML_ATTR_numalign_VAL_center_},
 {MathML_ATTR_numalign, "left", MathML_ATTR_numalign_VAL_left_},
 {MathML_ATTR_numalign, "right", MathML_ATTR_numalign_VAL_right_},

 {MathML_ATTR_overflow, "scroll", MathML_ATTR_overflow_VAL_scroll},
 {MathML_ATTR_overflow, "elide", MathML_ATTR_overflow_VAL_elide},
 {MathML_ATTR_overflow, "truncate", MathML_ATTR_overflow_VAL_truncate},
 {MathML_ATTR_overflow, "scale", MathML_ATTR_overflow_VAL_scale_},

 {MathML_ATTR_rowalign_mtr, "top", MathML_ATTR_rowalign_mtr_VAL_top_},
 {MathML_ATTR_rowalign_mtr, "bottom", MathML_ATTR_rowalign_mtr_VAL_bottom_},
 {MathML_ATTR_rowalign_mtr, "center", MathML_ATTR_rowalign_mtr_VAL_center},
 {MathML_ATTR_rowalign_mtr, "baseline", MathML_ATTR_rowalign_mtr_VAL_baseline},
 {MathML_ATTR_rowalign_mtr, "axis", MathML_ATTR_rowalign_mtr_VAL_axis},

 {MathML_ATTR_separator, "true", MathML_ATTR_separator_VAL_true},
 {MathML_ATTR_separator, "false", MathML_ATTR_separator_VAL_false},

 {MathML_ATTR_side, "left", MathML_ATTR_side_VAL_left_},
 {MathML_ATTR_side, "leftoverlap", MathML_ATTR_side_VAL_leftoverlap},
 {MathML_ATTR_side, "right", MathML_ATTR_side_VAL_right_},
 {MathML_ATTR_side, "rightoverlap", MathML_ATTR_side_VAL_rightoverlap},

 {MathML_ATTR_stretchy, "true", MathML_ATTR_stretchy_VAL_true},
 {MathML_ATTR_stretchy, "false", MathML_ATTR_stretchy_VAL_false},

 {MathML_ATTR_symmetric, "true", MathML_ATTR_symmetric_VAL_true},
 {MathML_ATTR_symmetric, "false", MathML_ATTR_symmetric_VAL_false},

 {MathML_ATTR_xml_space, "default", MathML_ATTR_xml_space_VAL_xml_space_default},
 {MathML_ATTR_xml_space, "preserve", MathML_ATTR_xml_space_VAL_xml_space_preserve},

 {0, "", 0}			/* Last entry. Mandatory */
};
