/* $Id: wmmenu.c,v 1.5 2000/02/06 03:25:48 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmmenu.h"
#include "wmmain.h"
#include "wmtitle.h"

static void wm_menu_raise(WmClient *client);
static void wm_menu_lower(WmClient *client);
static void wm_menu_iconify(WmClient *client);
static void wm_menu_deiconify(WmClient *client);
static void wm_menu_toggle_iconify(WmClient *client);
static void wm_menu_close(WmClient *client);

static GtkMenu *previous_popup = NULL;
void wm_menu_popup_temporarily(GtkMenu *menu, GtkWidget *parent_menu_shell,
			       GtkWidget *parent_menu_item,
			       GtkMenuPositionFunc func,
			       gpointer data, guint button,
			       guint32 activate_time)
{
    gtk_menu_popup(menu, parent_menu_shell, parent_menu_item, func, data,
		   button, activate_time);
    if(previous_popup) {
	wm_message("WmMenu: destroy preivous_popup menu\n");
	gtk_widget_destroy(GTK_WIDGET(previous_popup));
    }
    previous_popup = menu;
}

/* ---------------------------------------------------------------------- */
GtkWidget* wm_menu_jobs(void)
{
    GtkWidget *menu, *client;
    GList *list;

    menu = gtk_menu_new();
    for(list = all_clients->list; list; list = list->next) {
	client = wm_title_menu_item_new(GTK_WIDGET(list->data));
	gtk_signal_connect_object(GTK_OBJECT(client), "activate",
				  GTK_SIGNAL_FUNC(wm_menu_raise), list->data);
	gtk_signal_connect_object(GTK_OBJECT(client), "activate",
				  GTK_SIGNAL_FUNC(wm_menu_deiconify),
				  list->data);
	gtk_menu_append(GTK_MENU(menu), client);
	gtk_widget_show(client);
    }
    return menu;
}

/* ٤ȤϤȤ, Ȥꤢ뤫. */
GtkWidget* wm_menu_group(WmGroup *group) 
{
    GtkWidget *menu, *submenu;
    GtkWidget *client;
    GtkWidget *close, *raise, *lower, *iconify;

    GList *list;

    menu = gtk_menu_new();

    for(list = group->list; list; list = list->next) {
	client = gtk_menu_item_new_with_label(WM_CLIENT_TITLE(list->data));

	submenu = gtk_menu_new();
	close   = gtk_menu_item_new_with_label("close");
	raise   = gtk_menu_item_new_with_label("raise");
	lower   = gtk_menu_item_new_with_label("lower");
	iconify = gtk_menu_item_new_with_label("iconify");

	gtk_signal_connect_object(GTK_OBJECT(raise), "activate",
				  GTK_SIGNAL_FUNC(wm_menu_raise), list->data);
	gtk_signal_connect_object(GTK_OBJECT(lower), "activate",
				  GTK_SIGNAL_FUNC(wm_menu_lower), list->data);
	gtk_signal_connect_object(GTK_OBJECT(iconify), "activate",
				  GTK_SIGNAL_FUNC(wm_menu_iconify),list->data);
	gtk_signal_connect_object(GTK_OBJECT(close),   "activate",
				  GTK_SIGNAL_FUNC(wm_menu_close), list->data);

	gtk_menu_append(GTK_MENU(submenu), raise);
	gtk_menu_append(GTK_MENU(submenu), iconify);
	gtk_menu_append(GTK_MENU(submenu), lower);
	gtk_menu_append(GTK_MENU(submenu), close);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(client), submenu);
	gtk_menu_append(GTK_MENU (menu), client);

	gtk_widget_show(close);
	gtk_widget_show(raise);
	gtk_widget_show(lower);
	gtk_widget_show(iconify);
	gtk_widget_show(client);
    }

    return menu;
}

/* WmButton/WmAction ȶĴ */
static void wm_menu_raise(WmClient *client)
{
    gdk_window_raise(gtk_widget_get_toplevel(GTK_WIDGET(client))->window);
}

static void wm_menu_lower(WmClient *client)
{
    gdk_window_lower(gtk_widget_get_toplevel(GTK_WIDGET(client))->window);
}

static void wm_menu_iconify(WmClient *client)
{
    if(WM_CLIENT_STATE(client) == NormalState) {
	wm_client_iconify(client);
    }
}

static void wm_menu_deiconify(WmClient *client)
{
   if(WM_CLIENT_STATE(client) == IconicState) {
	gtk_widget_show(GTK_WIDGET(client));
    }
}

static void wm_menu_toggle_iconify(WmClient *client)
{
    if(WM_CLIENT_STATE(client) == NormalState) {
	wm_client_iconify(client);
    } else if(WM_CLIENT_STATE(client) == IconicState) {
	gtk_widget_show(GTK_WIDGET(client));
    }
}

static void wm_menu_close(WmClient *client)
{
    wm_client_delete(client);
}

