/* $Id: wmdesign.c,v 1.8 2000/11/11 23:41:54 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h> /* malloc  */
#include "wmdesign.h"
#include "wmmain.h"

typedef struct {
    guint16 red;
    guint16 green;
    guint16 blue;
} wmDesignColor;

static void wm_design_color_real_background(GtkWidget* widget, gpointer data);

static void wm_design_color_real_background(GtkWidget* widget, gpointer data)
{
    GdkColor     gdkColor;
    GdkColormap *colormap;

    colormap = gdk_window_get_colormap(widget->window);
    gdkColor.red   = ((wmDesignColor *)data)->red;
    gdkColor.green = ((wmDesignColor *)data)->green;
    gdkColor.blue  = ((wmDesignColor *)data)->blue;
    gdk_color_alloc (colormap, &gdkColor);
    gdk_window_set_background (widget->window, &gdkColor);
    g_free(data);
}


/* åȤطʿѤ롣 */
void wm_design_color_background(GtkWidget* widget,
				guint16 red, guint16 green, guint16 blue)
{
    wmDesignColor *color;
    color = (wmDesignColor *)g_malloc(sizeof(wmDesignColor));
    color->red   = red;
    color->green = green;
    color->blue  = blue;
    gtk_signal_connect(GTK_OBJECT(widget), "realize",
		       GTK_SIGNAL_FUNC(wm_design_color_real_background), 
		       (gpointer)color);
}

/* ٥򥦥åȤĥĤ */
void wm_design_label_pack(GtkWidget *widget, gchar *string)
{
    GtkWidget *label;

    label = gtk_label_new(string);
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    if(GTK_IS_BOX(widget)) {
	gtk_box_pack_start(GTK_BOX(widget), label, FALSE, FALSE, 0);
    } else {
	gtk_container_add(GTK_CONTAINER(widget), label);
    }
    gtk_widget_show(label);
}


 
/* xpm ե򥦥åȤˤϤĤ롣 */
void wm_design_xpm_pack(GtkWidget *widget, gchar *xpmFilename)
{
    GtkWidget *pixmapwid;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle  *style;

    pixmap = 
	gdk_pixmap_create_from_xpm (dummy_window->window, &mask,
				    &dummy_window->style->bg[GTK_STATE_NORMAL],
				    xpmFilename);
    pixmapwid = gtk_pixmap_new (pixmap, mask);

    /* ԥåޥåפ򥦥åȤ˥ѥå */
    if(GTK_IS_BOX(widget)) {
	gtk_box_pack_start (GTK_BOX(widget), pixmapwid, FALSE, FALSE, 0);
    } else {
	gtk_container_add (GTK_CONTAINER(widget), pixmapwid);
    }
    gtk_widget_show(pixmapwid);
}
