/***************************************************************************
 *   Copyright (c) 2007  Nikolaj Hald Nielsen <nhnFreespirit@gmail.com>    *
 *                 2007  Jeff Mitchell <kde-dev@emailgoeshere.com>         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef GRAPHICSITEMSCALER_H
#define GRAPHICSITEMSCALER_H

#include "contextbox.h"

#include <QObject>
#include <QGraphicsPixmapItem>
#include <QGraphicsRectItem>
#include <QTimeLine>

namespace Context
{

    /**
    A simple "widget" for the context view that provides a fading image
    Will be ported to use QGraphicsSvgItem once that successfully renders
    the Amarok logo file

	@author Nikolaj Hald Nielsen <nhnFreespirit@gmail.com>
    */
    class GraphicsItemScaler : public QObject
    {

    Q_OBJECT
    public:
        explicit GraphicsItemScaler( ContextBox *item );
        ~GraphicsItemScaler();

        void setTargetSize( int width, int height );
        void setDuration( int ms );
        void setFPS( int fps );
        void setDelay( int ms ) { m_delay = ms; }
        void startScaling();
        ContextBox* contentItem() { return m_contentItem; }
        int originalWidth() { return m_originalWidth; }
        int originalHeight() { return m_originalHeight; }

    signals:
        void animationComplete();

    public slots:
        void scaleSlot( int step );
        void scaleFinished();
        void begin();

    private:
        QTimeLine*  m_timeLine;
        ContextBox* m_contentItem;

        qreal m_currWidth;
        qreal m_currHeight;
        int m_originalWidth;
        int m_originalHeight;
        int m_tgtWidth;
        int m_tgtHeight;
        bool m_negativeWidth;
        bool m_negativeHeight;
        int m_fps;
        int m_duration;
        int m_animationSteps;
        int m_delay;

    };

}


#endif
