/*
 * Copyright © 2011 Keith Packard <keithp@keithp.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

package org.altusmetrum.AltosLib;


public class AltosTelemetryRecordConfiguration extends AltosTelemetryRecordRaw {
	int	device_type;
	int	flight;
	int	config_major;
	int	config_minor;
	int	apogee_delay;
	int	main_deploy;
	int	flight_log_max;
	String	callsign;
	String	version;

	public AltosTelemetryRecordConfiguration(int[] in_bytes) {
		super(in_bytes);

		device_type    = uint8(5);
		flight         = uint16(6);
		config_major   = uint8(8);
		config_minor   = uint8(9);
		apogee_delay   = uint16(10);
		main_deploy    = uint16(12);
		flight_log_max = uint16(14);
		callsign       = string(16, 8);
		version        = string(24, 8);
	}

	public AltosRecord update_state(AltosRecord previous) {
		AltosRecord	next = super.update_state(previous);

		next.device_type = device_type;
		next.flight = flight;
		next.config_major = config_major;
		next.config_minor = config_minor;
		next.apogee_delay = apogee_delay;
		next.main_deploy = main_deploy;
		next.flight_log_max = flight_log_max;

		next.callsign = callsign;
		next.firmware_version = version;

		next.seen |= AltosRecord.seen_deploy | AltosRecord.seen_flight;

		return next;
	}
}
