(**************************************************************************)
(*                                                                        *)
(*     The Alt-ergo theorem prover                                        *)
(*     Copyright (C) 2006-2008                                            *)
(*                                                                        *)
(*     Sylvain Conchon                                                    *)
(*     Evelyne Contejean                                                  *)
(*     CNRS-LRI-Universite Paris Sud                                      *)
(*                                                                        *)
(*   This file is distributed under the terms of the CeCILL-C licence     *)
(*                                                                        *)
(**************************************************************************)

type gsubst = { sbt : Term.subst ; gen : int ; goal : bool}

module type X = sig
  type t

  val class_of : t -> Term.t -> Term.t list
  val query : Literal.t -> t -> bool
end

module type S = sig
  type t
  type uf

  val empty : t
  val add : int -> bool -> Formula.t option -> Term.t -> t -> t 
  val matching : Formula.t -> Term.t list -> t -> uf ->  gsubst list
end

module Make (X : X) : S with type uf = X.t
