/* A lexical scanner generated by flex*/

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define EDIF_FLEX_MAJOR_VERSION 2
#define EDIF_FLEX_MINOR_VERSION 5

#include <stdio.h>
#include <unistd.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

/* Use prototypes in function declarations. */
#define EDIF_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define EDIF_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define EDIF_USE_PROTOS
#define EDIF_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define EDIF_USE_CONST
#define EDIF_USE_PROTOS
#endif

#ifdef EDIF_USE_CONST
#define edifconst const
#else
#define edifconst
#endif


#ifdef EDIF_USE_PROTOS
#define EDIF_PROTO(proto) proto
#else
#define EDIF_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define EDIF_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define EDIF_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN edif_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The EDIFSTATE alias is for lex
 * compatibility.
 */
#define EDIF_START ((edif_start - 1) / 2)
#define EDIFSTATE EDIF_START

/* Action number for EOF rule of a given start state. */
#define EDIF_STATE_EOF(state) (EDIF_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define EDIF_NEW_FILE edifrestart( edifin )

#define EDIF_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define EDIF_BUF_SIZE 16384

typedef struct edif_buffer_state *EDIF_BUFFER_STATE;

extern int edifleng;
extern FILE *edifin, *edifout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		edifless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the edifless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define edifless(n) \
	do \
		{ \
		/* Undo effects of setting up ediftext. */ \
		*edif_cp = edif_hold_char; \
		EDIF_RESTORE_EDIF_MORE_OFFSET \
		edif_c_buf_p = edif_cp = edif_bp + n - EDIF_MORE_ADJ; \
		EDIF_DO_BEFORE_ACTION; /* set up ediftext again */ \
		} \
	while ( 0 )

#define unput(c) edifunput( c, ediftext_ptr )

/* Some routines like edif_flex_realloc() are emitted as static but are
   not called by all lexers. This generates warnings in some compilers,
   notably GCC. Arrange to suppress these. */
#ifdef __GNUC__
#define EDIF_MAY_BE_UNUSED __attribute__((unused))
#else
#define EDIF_MAY_BE_UNUSED
#endif

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int edif_size_t;


struct edif_buffer_state
	{
	FILE *edif_input_file;

	char *edif_ch_buf;		/* input buffer */
	char *edif_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	edif_size_t edif_buf_size;

	/* Number of characters read into edif_ch_buf, not including EOB
	 * characters.
	 */
	int edif_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int edif_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int edif_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int edif_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int edif_fill_buffer;

	int edif_buffer_status;
#define EDIF_BUFFER_NEW 0
#define EDIF_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as EDIF_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via edifrestart()), so that the user can continue scanning by
	 * just pointing edifin at a new input file.
	 */
#define EDIF_BUFFER_EOF_PENDING 2
	};

static EDIF_BUFFER_STATE edif_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define EDIF_CURRENT_BUFFER edif_current_buffer


/* edif_hold_char holds the character lost when ediftext is formed. */
static char edif_hold_char;

static int edif_n_chars;		/* number of characters read into edif_ch_buf */


int edifleng;

/* Points to current character in buffer. */
static char *edif_c_buf_p = (char *) 0;
static int edif_init = 1;		/* whether we need to initialize */
static int edif_start = 0;	/* start state number */

/* Flag which is used to allow edifwrap()'s to do buffer switches
 * instead of setting up a fresh edifin.  A bit of a hack ...
 */
static int edif_did_buffer_switch_on_eof;

void edifrestart EDIF_PROTO(( FILE *input_file ));

void edif_switch_to_buffer EDIF_PROTO(( EDIF_BUFFER_STATE new_buffer ));
void edif_load_buffer_state EDIF_PROTO(( void ));
EDIF_BUFFER_STATE edif_create_buffer EDIF_PROTO(( FILE *file, int size ));
void edif_delete_buffer EDIF_PROTO(( EDIF_BUFFER_STATE b ));
void edif_init_buffer EDIF_PROTO(( EDIF_BUFFER_STATE b, FILE *file ));
void edif_flush_buffer EDIF_PROTO(( EDIF_BUFFER_STATE b ));
#define EDIF_FLUSH_BUFFER edif_flush_buffer( edif_current_buffer )

EDIF_BUFFER_STATE edif_scan_buffer EDIF_PROTO(( char *base, edif_size_t size ));
EDIF_BUFFER_STATE edif_scan_string EDIF_PROTO(( edifconst char *edif_str ));
EDIF_BUFFER_STATE edif_scan_bytes EDIF_PROTO(( edifconst char *bytes, int len ));

static void *edif_flex_alloc EDIF_PROTO(( edif_size_t ));
static void *edif_flex_realloc EDIF_PROTO(( void *, edif_size_t )) EDIF_MAY_BE_UNUSED;
static void edif_flex_free EDIF_PROTO(( void * ));

#define edif_new_buffer edif_create_buffer

#define edif_set_interactive(is_interactive) \
	{ \
	if ( ! edif_current_buffer ) \
		edif_current_buffer = edif_create_buffer( edifin, EDIF_BUF_SIZE ); \
	edif_current_buffer->edif_is_interactive = is_interactive; \
	}

#define edif_set_bol(at_bol) \
	{ \
	if ( ! edif_current_buffer ) \
		edif_current_buffer = edif_create_buffer( edifin, EDIF_BUF_SIZE ); \
	edif_current_buffer->edif_at_bol = at_bol; \
	}

#define EDIF_AT_BOL() (edif_current_buffer->edif_at_bol)

typedef unsigned char EDIF_CHAR;
FILE *edifin = (FILE *) 0, *edifout = (FILE *) 0;
typedef int edif_state_type;
extern char *ediftext;
#define ediftext_ptr ediftext

static edif_state_type edif_get_previous_state EDIF_PROTO(( void ));
static edif_state_type edif_try_NUL_trans EDIF_PROTO(( edif_state_type current_state ));
static int edif_get_next_buffer EDIF_PROTO(( void ));
static void edif_fatal_error EDIF_PROTO(( edifconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up ediftext.
 */
#define EDIF_DO_BEFORE_ACTION \
	ediftext_ptr = edif_bp; \
	edifleng = (int) (edif_cp - edif_bp); \
	edif_hold_char = *edif_cp; \
	*edif_cp = '\0'; \
	edif_c_buf_p = edif_cp;

#define EDIF_NUM_RULES 45
#define EDIF_END_OF_BUFFER 46
static edifconst short int edif_accept[265] =
    {   0,
        1,    1,   46,   45,    1,    2,   43,   43,   45,   44,
       39,   43,   43,   43,   43,   43,   43,    1,    0,   43,
       43,    0,   40,   40,   40,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   39,   43,   43,   43,   43,
       43,   43,   41,   41,   40,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
       43,   43,   43,   43,   43,   43,   11,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,   19,
       40,   40,   40,   40,   43,   43,   43,   43,   43,   43,
       40,    7,   40,   40,    3,   40,   40,   40,   40,   40,

       40,   34,   26,   40,   40,   15,   43,   28,   29,   43,
       43,   43,   38,   40,   40,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
        0,   40,   40,   40,   43,   43,   30,   12,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   20,   40,   35,
       40,   40,   40,   40,   37,    0,    0,    0,   40,   40,
       10,   36,   24,   40,   40,   40,   40,   40,   40,   40,
       40,    6,   40,   40,   31,   40,    0,    0,   23,   40,
        9,   18,   40,   40,   40,    8,   21,   40,   40,   40,
       32,   13,    0,   16,   27,    5,   40,   40,   17,   40,

       40,    0,   40,   40,   25,   40,    0,    4,   33,   40,
        0,   22,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   14,    0,
        0,    0,    0,    0
    } ;

static edifconst int edif_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    5,    5,    5,    7,    5,    8,
        9,    5,    5,    5,   10,   11,    5,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   13,   13,   13,
       13,   13,   13,   13,   14,   15,   16,   17,   18,   19,
       20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
       30,   31,   32,   33,   34,   35,   36,   37,   38,   30,
       39,   39,   39,   39,   40,   39,   41,   42,   43,   44,

       45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
       55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
       65,   57,   66,   66,   66,   66,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static edifconst int edif_meta[67] =
    {   0,
        1,    2,    1,    3,    4,    5,    5,    4,    4,    5,
        5,    5,    4,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    4,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    4
    } ;

static edifconst short int edif_base[270] =
    {   0,
        0,    0,  621,  666,   65,  666,   66,    0,  131,  666,
      608,   50,   45,   55,   42,   55,   58,   79,  613,  193,
        0,    0,  258,   51,   66,   63,   76,   60,   60,   67,
       72,   78,   70,   73,   75,  605,   75,  175,  167,  174,
      179,  191,  609,  207,  179,  189,  190,  187,  199,  189,
      191,  203,  211,  202,  203,  205,  208,  212,  215,  225,
      243,  229,  230,  243,  242,  248,    0,  264,  254,  249,
      268,  273,  276,  263,  279,  273,  284,  302,  300,    0,
      289,  296,  312,  292,  298,  297,  298,  310,  299,  316,
      297,  305,  319,  323,  315,  310,  329,  315,  329,  334,

      333,    0,  354,  336,  343,  378,  349,    0,    0,  340,
      350,  355,    0,  369,  350,  362,  357,  373,  374,  366,
      367,  376,  380,  369,  370,  375,  382,  387,  376,  390,
      104,  435,  438,  443,  407,  392,    0,    0,  407,  401,
      400,  419,  409,  417,  435,  439,  444,    0,  421,    0,
      429,  430,  444,  431,    0,  465,  470,  475,  490,  491,
        0,    0,    0,  452,  448,  456,  469,  464,  475,  483,
      486,  472,  471,  472,    0,  468,  511,  490,  514,  517,
        0,    0,  490,  499,  504,    0,  503,  520,  522,  527,
        0,    0,  524,  541,    0,    0,  520,  532,    0,  533,

      527,  519,  529,  538,    0,  542,  526,    0,    0,  542,
      525,    0,  535,  548,  574,  592,  596,  599,  574,  566,
      569,  544,  587,  573,  578,  555,  543,  548,  585,  574,
      582,  554,  541,  546,  545,  549,  544,  509,  518,  411,
      443,  440,  359,  209,  216,  202,  219,  195,  197,  150,
      105,   95,  108,  108,  118,   73,   75,   84,  666,   92,
       61,   77,   26,  666,  649,   73,  652,  656,  660
    } ;

static edifconst short int edif_def[270] =
    {   0,
      264,    1,  264,  264,  264,  264,  265,  266,  264,  264,
      266,  266,  266,  266,  266,  266,  266,  264,  267,  265,
      266,    9,    9,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,  266,  266,  266,  266,  266,
      266,  266,  267,  265,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
      266,  266,  266,  266,  266,  266,  266,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,  266,  266,  266,  266,  266,  266,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,

       23,   23,   23,   23,   23,  268,  266,  266,  266,  266,
      266,  266,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
      269,  268,  268,  268,  266,  266,  266,  266,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,  269,  264,  264,  268,  268,
      266,  266,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,  264,  264,  268,  268,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,  264,  268,   23,   23,   23,   23,   23,   23,

       23,  264,   23,   23,   23,   23,  264,   23,   23,   23,
      264,   23,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,    0,  264,  264,  264,  264,  264
    } ;

static edifconst short int edif_nxt[733] =
    {   0,
        4,    5,    6,    5,    4,    7,    8,    9,   10,    8,
        8,   11,    4,    8,    8,    8,    8,    8,    8,   12,
        8,   13,    8,    8,    8,    8,   14,   15,    8,    8,
       16,    8,   17,    8,    8,    8,    8,    8,    4,    8,
        8,    8,    8,    8,    8,    8,   12,    8,   13,    8,
        8,    8,    8,   14,   15,    8,    8,   16,    8,   17,
        8,    8,    8,    8,    8,    4,   18,   37,   18,   19,
       19,   38,   39,   19,   19,   40,   41,   21,   19,   42,
       18,   45,   18,   46,   48,  259,   51,   52,   53,   54,
       59,   55,   49,   47,   37,   56,   60,   57,   38,   39,

       58,   61,   40,   41,   19,  131,   42,  131,   45,  259,
       46,   48,   50,   51,   52,   53,   54,   59,   55,   49,
       47,  263,   56,   60,   57,  262,  259,   58,   61,  261,
      259,   19,   22,  259,   22,  260,   23,   23,  259,   50,
       23,   23,   23,  258,   24,   23,   25,   26,   27,   23,
       23,   23,   28,   29,   23,   30,   31,   32,   23,   33,
       23,   34,   23,   23,   23,   35,   23,   23,   23,  257,
       23,   24,   23,   25,   26,   27,   23,   23,   23,   28,
       29,   23,   30,   31,   32,   23,   33,   23,   34,   23,
       23,   23,   35,   23,   23,   23,   19,   19,   44,   64,

       19,   19,   62,   63,  256,   19,   65,   66,   67,   68,
       19,   19,   44,   69,   19,   19,   70,   71,  255,   19,
       72,   73,   74,   75,   76,   77,   64,   78,   79,   62,
       63,   19,  254,   65,   66,   67,   68,   80,   81,   82,
       69,   83,   84,   70,   71,   19,  253,   72,   73,   74,
       75,   76,   77,  252,   78,   79,  251,  250,   19,  264,
       85,  264,   86,   87,   80,   81,   82,   88,   83,   84,
       89,   23,   19,   23,   23,   23,   90,   91,   92,   23,
       23,   93,   23,   23,   23,   94,   23,   85,   23,   86,
       87,   95,   23,   96,   88,   97,   98,   89,   23,   99,

       23,   23,   23,   90,   91,   92,   23,   23,   93,   23,
       23,   23,   94,   23,  100,   23,  101,  102,   95,   23,
       96,  103,   97,   98,  104,  105,   99,  106,  107,  108,
      109,  110,  111,  112,  113,  114,  116,  115,  117,  118,
      120,  100,  121,  101,  102,  122,  123,  124,  103,  119,
      125,  104,  105,  129,  106,  107,  108,  109,  110,  111,
      112,  113,  114,  116,  115,  117,  118,  120,  130,  121,
      135,  136,  122,  123,  124,  126,  119,  125,  127,  131,
      129,  131,  137,  249,  128,  138,  139,  140,  141,  142,
      143,  144,  145,  146,  147,  130,  148,  135,  136,  149,

      150,  151,  126,  152,  153,  127,  154,  155,  133,  137,
      134,  128,  138,  139,  140,  141,  142,  143,  144,  145,
      146,  147,  161,  148,  162,  163,  149,  150,  151,  164,
      152,  153,  165,  154,  155,  133,  157,  134,  157,  157,
      166,  157,  158,  167,  157,  158,  157,  168,  169,  161,
      158,  162,  163,  248,  170,  159,  164,  171,  172,  165,
      173,  174,  175,  176,  247,  246,  157,  166,  157,  181,
      167,  157,  158,  157,  168,  169,  177,  158,  177,  182,
      160,  170,  159,  183,  171,  172,  184,  173,  174,  175,
      176,  157,  157,  157,  157,  185,  181,  158,  158,  186,

      187,  188,  189,  190,  191,  192,  182,  160,  179,  178,
      183,  193,  177,  184,  177,  157,  195,  157,  157,  180,
      157,  158,  185,  196,  158,  197,  186,  187,  188,  189,
      190,  191,  192,  198,  194,  179,  178,  199,  193,  200,
      201,  202,  157,  195,  157,  178,  180,  203,  158,  204,
      196,  205,  197,  206,  207,  208,  209,  210,  211,  212,
      198,  194,  213,  214,  199,  215,  200,  201,  202,  245,
      244,  243,  178,  242,  203,  216,  204,  216,  205,  241,
      206,  207,  208,  209,  210,  211,  212,  240,  217,  213,
      214,  239,  215,  216,  238,  216,  237,  236,  235,  218,

      234,  233,  232,  231,  230,  219,  217,  229,  228,  227,
      226,  225,  224,  223,   43,  220,   36,  218,   43,   36,
      264,  264,  264,  219,  264,  264,  221,  264,  264,  264,
      264,  264,  222,  220,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  221,  264,  264,  264,  264,  264,
      222,   20,   20,   20,   19,   19,   19,  132,  132,  264,
      132,  156,  156,  264,  156,    3,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,

      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264
    } ;

static edifconst short int edif_chk[733] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    5,   12,    5,    7,
        7,   13,   14,    7,    7,   15,   16,  266,    7,   17,
       18,   24,   18,   25,   26,  263,   28,   29,   30,   31,
       34,   32,   27,   25,   12,   32,   35,   33,   13,   14,

       33,   37,   15,   16,    7,  131,   17,  131,   24,  262,
       25,   26,   27,   28,   29,   30,   31,   34,   32,   27,
       25,  261,   32,   35,   33,  260,  258,   33,   37,  257,
      256,    7,    9,  255,    9,  254,    9,    9,  253,   27,
        9,    9,    9,  252,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,  251,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,   20,   20,   20,   39,

       20,   20,   38,   38,  250,   20,   40,   41,   42,   45,
       44,   44,   44,   46,   44,   44,   47,   48,  249,   44,
       49,   50,   51,   51,   52,   53,   39,   54,   55,   38,
       38,   20,  248,   40,   41,   42,   45,   56,   57,   58,
       46,   59,   60,   47,   48,   44,  247,   49,   50,   51,
       51,   52,   53,  246,   54,   55,  245,  244,   20,   23,
       61,   23,   62,   63,   56,   57,   58,   64,   59,   60,
       65,   23,   44,   23,   23,   23,   66,   68,   69,   23,
       23,   70,   23,   23,   23,   71,   23,   61,   23,   62,
       63,   72,   23,   73,   64,   74,   75,   65,   23,   76,

       23,   23,   23,   66,   68,   69,   23,   23,   70,   23,
       23,   23,   71,   23,   77,   23,   78,   79,   72,   23,
       73,   81,   74,   75,   82,   83,   76,   84,   85,   86,
       87,   88,   89,   90,   91,   92,   93,   92,   94,   95,
       96,   77,   97,   78,   79,   98,   99,  100,   81,   95,
      101,   82,   83,  104,   84,   85,   86,   87,   88,   89,
       90,   91,   92,   93,   92,   94,   95,   96,  105,   97,
      107,  110,   98,   99,  100,  103,   95,  101,  103,  106,
      104,  106,  111,  243,  103,  112,  114,  115,  116,  117,
      118,  119,  120,  121,  122,  105,  123,  107,  110,  124,

      125,  126,  103,  127,  128,  103,  129,  130,  106,  111,
      106,  103,  112,  114,  115,  116,  117,  118,  119,  120,
      121,  122,  135,  123,  136,  139,  124,  125,  126,  140,
      127,  128,  141,  129,  130,  106,  132,  106,  132,  133,
      142,  133,  132,  143,  134,  133,  134,  144,  145,  135,
      134,  136,  139,  242,  146,  133,  140,  147,  149,  141,
      151,  152,  153,  154,  241,  240,  156,  142,  156,  164,
      143,  157,  156,  157,  144,  145,  158,  157,  158,  165,
      134,  146,  133,  166,  147,  149,  167,  151,  152,  153,
      154,  159,  160,  159,  160,  168,  164,  159,  160,  169,

      170,  171,  172,  173,  174,  176,  165,  134,  159,  158,
      166,  178,  177,  167,  177,  179,  183,  179,  180,  160,
      180,  179,  168,  184,  180,  185,  169,  170,  171,  172,
      173,  174,  176,  187,  180,  159,  158,  188,  178,  189,
      190,  193,  194,  183,  194,  177,  160,  197,  194,  198,
      184,  200,  185,  201,  202,  203,  204,  206,  207,  210,
      187,  180,  211,  213,  188,  214,  189,  190,  193,  239,
      238,  237,  177,  236,  197,  215,  198,  215,  200,  235,
      201,  202,  203,  204,  206,  207,  210,  234,  215,  211,
      213,  233,  214,  216,  232,  216,  231,  230,  229,  215,

      228,  227,  226,  225,  224,  215,  216,  223,  222,  221,
      220,  219,  218,  217,   43,  215,   36,  216,   19,   11,
        3,    0,    0,  216,    0,    0,  215,    0,    0,    0,
        0,    0,  215,  216,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  216,    0,    0,    0,    0,    0,
      216,  265,  265,  265,  267,  267,  267,  268,  268,    0,
      268,  269,  269,    0,  269,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,

      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264,  264,  264,  264,  264,  264,  264,  264,  264,
      264,  264
    } ;

static edif_state_type edif_last_accepting_state;
static char *edif_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define edifmore() edifmore_used_but_not_detected
#define EDIF_MORE_ADJ 0
#define EDIF_RESTORE_EDIF_MORE_OFFSET
char *ediftext;
#line 1 "../../../src/mbkedif/src/parser_l.l"
#define INITIAL 0
#line 5 "../../../src/mbkedif/src/parser_l.l"
#include <string.h>
#include "parser_y.h"

#undef ECHO
#define ECHO {strcpy(ediflval.sval, ediftext);} 
void edifJumpOver();
int  ediflineno;

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef EDIF_SKIP_EDIFWRAP
#ifdef __cplusplus
extern "C" int edifwrap EDIF_PROTO(( void ));
#else
extern int edifwrap EDIF_PROTO(( void ));
#endif
#endif

#ifndef EDIF_NO_UNPUT
static void edifunput EDIF_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef ediftext_ptr
static void edif_flex_strncpy EDIF_PROTO(( char *, edifconst char *, int ));
#endif

#ifdef EDIF_NEED_STRLEN
static int edif_flex_strlen EDIF_PROTO(( edifconst char * ));
#endif

#ifndef EDIF_NO_INPUT
#ifdef __cplusplus
static int edifinput EDIF_PROTO(( void ));
#else
static int input EDIF_PROTO(( void ));
#endif
#endif

#if EDIF_STACK_USED
static int edif_start_stack_ptr = 0;
static int edif_start_stack_depth = 0;
static int *edif_start_stack = 0;
#ifndef EDIF_NO_PUSH_STATE
static void edif_push_state EDIF_PROTO(( int new_state ));
#endif
#ifndef EDIF_NO_POP_STATE
static void edif_pop_state EDIF_PROTO(( void ));
#endif
#ifndef EDIF_NO_TOP_STATE
static int edif_top_state EDIF_PROTO(( void ));
#endif

#else
#define EDIF_NO_PUSH_STATE 1
#define EDIF_NO_POP_STATE 1
#define EDIF_NO_TOP_STATE 1
#endif

#ifdef EDIF_MALLOC_DECL
EDIF_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef EDIF_READ_BUF_SIZE
#define EDIF_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( ediftext, edifleng, 1, edifout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or EDIF_NULL,
 * is returned in "result".
 */
#ifndef EDIF_INPUT
#define EDIF_INPUT(buf,result,max_size) \
	if ( edif_current_buffer->edif_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( edifin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( edifin ) ) \
			EDIF_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, edifin )) == 0) \
		  && ferror( edifin ) ) \
		EDIF_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "edifterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef edifterminate
#define edifterminate() return EDIF_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef EDIF_START_STACK_INCR
#define EDIF_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef EDIF_FATAL_ERROR
#define EDIF_FATAL_ERROR(msg) edif_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef EDIF_DECL
#define EDIF_DECL int ediflex EDIF_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after ediftext and edifleng
 * have been set up.
 */
#ifndef EDIF_USER_ACTION
#define EDIF_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef EDIF_BREAK
#define EDIF_BREAK break;
#endif

#define EDIF_RULE_SETUP \
	EDIF_USER_ACTION

EDIF_DECL
	{
	register edif_state_type edif_current_state;
	register char *edif_cp = NULL, *edif_bp = NULL;
	register int edif_act;

#line 25 "../../../src/mbkedif/src/parser_l.l"



	if ( edif_init )
		{
		edif_init = 0;

#ifdef EDIF_USER_INIT
		EDIF_USER_INIT;
#endif

		if ( ! edif_start )
			edif_start = 1;	/* first start state */

		if ( ! edifin )
			edifin = stdin;

		if ( ! edifout )
			edifout = stdout;

		if ( ! edif_current_buffer )
			edif_current_buffer =
				edif_create_buffer( edifin, EDIF_BUF_SIZE );

		edif_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		edif_cp = edif_c_buf_p;

		/* Support of ediftext. */
		*edif_cp = edif_hold_char;

		/* edif_bp points to the position in edif_ch_buf of the start of
		 * the current run.
		 */
		edif_bp = edif_cp;

		edif_current_state = edif_start;
edif_match:
		do
			{
			register EDIF_CHAR edif_c = edif_ec[EDIF_SC_TO_UI(*edif_cp)];
			if ( edif_accept[edif_current_state] )
				{
				edif_last_accepting_state = edif_current_state;
				edif_last_accepting_cpos = edif_cp;
				}
			while ( edif_chk[edif_base[edif_current_state] + edif_c] != edif_current_state )
				{
				edif_current_state = (int) edif_def[edif_current_state];
				if ( edif_current_state >= 265 )
					edif_c = edif_meta[(unsigned int) edif_c];
				}
			edif_current_state = edif_nxt[edif_base[edif_current_state] + (unsigned int) edif_c];
			++edif_cp;
			}
		while ( edif_base[edif_current_state] != 666 );

edif_find_action:
		edif_act = edif_accept[edif_current_state];
		if ( edif_act == 0 )
			{ /* have to back up */
			edif_cp = edif_last_accepting_cpos;
			edif_current_state = edif_last_accepting_state;
			edif_act = edif_accept[edif_current_state];
			}

		EDIF_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( edif_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of EDIF_DO_BEFORE_ACTION */
			*edif_cp = edif_hold_char;
			edif_cp = edif_last_accepting_cpos;
			edif_current_state = edif_last_accepting_state;
			goto edif_find_action;

case 1:
EDIF_RULE_SETUP
#line 27 "../../../src/mbkedif/src/parser_l.l"
{ }
	EDIF_BREAK
case 2:
EDIF_RULE_SETUP
#line 28 "../../../src/mbkedif/src/parser_l.l"
{ ediflineno ++; }
	EDIF_BREAK
case 3:
EDIF_RULE_SETUP
#line 29 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_EDIF ; }
	EDIF_BREAK
case 4:
EDIF_RULE_SETUP
#line 30 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_EDIFVERSION ; }
	EDIF_BREAK
case 5:
EDIF_RULE_SETUP
#line 31 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_EDIFLEVEL ; }
	EDIF_BREAK
case 6:
EDIF_RULE_SETUP
#line 32 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_LIBRARY ; }
	EDIF_BREAK
case 7:
EDIF_RULE_SETUP
#line 33 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_CELL ; }
	EDIF_BREAK
case 8:
EDIF_RULE_SETUP
#line 34 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_EXTERNAL ; }
	EDIF_BREAK
case 9:
EDIF_RULE_SETUP
#line 35 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_CELLTYPE ; }
	EDIF_BREAK
case 10:
EDIF_RULE_SETUP
#line 36 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_CELLTYPE_GENERIC ; }
	EDIF_BREAK
case 11:
EDIF_RULE_SETUP
#line 37 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_CELLTYPE_TIE ; }
	EDIF_BREAK
case 12:
EDIF_RULE_SETUP
#line 38 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_CELLTYPE_RIPPER ; }
	EDIF_BREAK
case 13:
EDIF_RULE_SETUP
#line 39 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_PROPERTY ; }
	EDIF_BREAK
case 14:
EDIF_RULE_SETUP
#line 40 "../../../src/mbkedif/src/parser_l.l"
{edifJumpOver(2);}
	EDIF_BREAK
case 15:
EDIF_RULE_SETUP
#line 41 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_VIEW ; }
	EDIF_BREAK
case 16:
EDIF_RULE_SETUP
#line 42 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_VIEWTYPE ; }
	EDIF_BREAK
case 17:
EDIF_RULE_SETUP
#line 43 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_INTERFACE ; }
	EDIF_BREAK
case 18:
EDIF_RULE_SETUP
#line 44 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_CONTENTS ; }
	EDIF_BREAK
case 19:
EDIF_RULE_SETUP
#line 45 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_NET ; }
	EDIF_BREAK
case 20:
EDIF_RULE_SETUP
#line 46 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_JOINED ; }
	EDIF_BREAK
case 21:
EDIF_RULE_SETUP
#line 47 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_INSTANCE ; }
	EDIF_BREAK
case 22:
EDIF_RULE_SETUP
#line 48 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_PORTINSTANCE ; }
	EDIF_BREAK
case 23:
EDIF_RULE_SETUP
#line 49 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_VIEWREF ; }
	EDIF_BREAK
case 24:
EDIF_RULE_SETUP
#line 50 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_CELLREF ; }
	EDIF_BREAK
case 25:
EDIF_RULE_SETUP
#line 51 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_LIBRARYREF ; }
	EDIF_BREAK
case 26:
EDIF_RULE_SETUP
#line 52 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_PORT ; }
	EDIF_BREAK
case 27:
EDIF_RULE_SETUP
#line 53 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_DIRECTION ; }
	EDIF_BREAK
case 28:
EDIF_RULE_SETUP
#line 54 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_INOUT ; }
	EDIF_BREAK
case 29:
EDIF_RULE_SETUP
#line 55 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_INPUT; }
	EDIF_BREAK
case 30:
EDIF_RULE_SETUP
#line 56 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_OUTPUT ; }
	EDIF_BREAK
case 31:
EDIF_RULE_SETUP
#line 57 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_PORTREF ; }
	EDIF_BREAK
case 32:
EDIF_RULE_SETUP
#line 58 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_PORTLIST ; }
	EDIF_BREAK
case 33:
EDIF_RULE_SETUP
#line 59 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_INSTANCEREF ; }
	EDIF_BREAK
case 34:
EDIF_RULE_SETUP
#line 60 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_NAME ; }
	EDIF_BREAK
case 35:
EDIF_RULE_SETUP
#line 61 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_MEMBER ;}
	EDIF_BREAK
case 36:
EDIF_RULE_SETUP
#line 62 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_NETLIST ; }
	EDIF_BREAK
case 37:
EDIF_RULE_SETUP
#line 63 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_RENAME ; }
	EDIF_BREAK
case 38:
EDIF_RULE_SETUP
#line 64 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_ARRAY ;}
	EDIF_BREAK
case 39:
EDIF_RULE_SETUP
#line 65 "../../../src/mbkedif/src/parser_l.l"
{ ECHO sscanf(ediftext, "%ld", &(ediflval.lval));
		       						return T_INTEGER ; 
							}
	EDIF_BREAK
case 40:
EDIF_RULE_SETUP
#line 68 "../../../src/mbkedif/src/parser_l.l"
{ edifJumpOver(1); }
	EDIF_BREAK
case 41:
EDIF_RULE_SETUP
#line 69 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_RENAME_STRING ; }
	EDIF_BREAK
case 42:
EDIF_RULE_SETUP
#line 70 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_STRING ; }
	EDIF_BREAK
case 43:
EDIF_RULE_SETUP
#line 71 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return T_IDENT; }
	EDIF_BREAK
case 44:
EDIF_RULE_SETUP
#line 72 "../../../src/mbkedif/src/parser_l.l"
{ ECHO return ')';}
	EDIF_BREAK
case 45:
EDIF_RULE_SETUP
#line 74 "../../../src/mbkedif/src/parser_l.l"
ECHO;
	EDIF_BREAK
case EDIF_STATE_EOF(INITIAL):
	edifterminate();

	case EDIF_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int edif_amount_of_matched_text = (int) (edif_cp - ediftext_ptr) - 1;

		/* Undo the effects of EDIF_DO_BEFORE_ACTION. */
		*edif_cp = edif_hold_char;
		EDIF_RESTORE_EDIF_MORE_OFFSET

		if ( edif_current_buffer->edif_buffer_status == EDIF_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed edifin at a new source and called
			 * ediflex().  If so, then we have to assure
			 * consistency between edif_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			edif_n_chars = edif_current_buffer->edif_n_chars;
			edif_current_buffer->edif_input_file = edifin;
			edif_current_buffer->edif_buffer_status = EDIF_BUFFER_NORMAL;
			}

		/* Note that here we test for edif_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since edif_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( edif_c_buf_p <= &edif_current_buffer->edif_ch_buf[edif_n_chars] )
			{ /* This was really a NUL. */
			edif_state_type edif_next_state;

			edif_c_buf_p = ediftext_ptr + edif_amount_of_matched_text;

			edif_current_state = edif_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * edif_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			edif_next_state = edif_try_NUL_trans( edif_current_state );

			edif_bp = ediftext_ptr + EDIF_MORE_ADJ;

			if ( edif_next_state )
				{
				/* Consume the NUL. */
				edif_cp = ++edif_c_buf_p;
				edif_current_state = edif_next_state;
				goto edif_match;
				}

			else
				{
				edif_cp = edif_c_buf_p;
				goto edif_find_action;
				}
			}

		else switch ( edif_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				edif_did_buffer_switch_on_eof = 0;

				if ( edifwrap() )
					{
					/* Note: because we've taken care in
					 * edif_get_next_buffer() to have set up
					 * ediftext, we can now set up
					 * edif_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * EDIF_NULL, it'll still work - another
					 * EDIF_NULL will get returned.
					 */
					edif_c_buf_p = ediftext_ptr + EDIF_MORE_ADJ;

					edif_act = EDIF_STATE_EOF(EDIF_START);
					goto do_action;
					}

				else
					{
					if ( ! edif_did_buffer_switch_on_eof )
						EDIF_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				edif_c_buf_p =
					ediftext_ptr + edif_amount_of_matched_text;

				edif_current_state = edif_get_previous_state();

				edif_cp = edif_c_buf_p;
				edif_bp = ediftext_ptr + EDIF_MORE_ADJ;
				goto edif_match;

			case EOB_ACT_LAST_MATCH:
				edif_c_buf_p =
				&edif_current_buffer->edif_ch_buf[edif_n_chars];

				edif_current_state = edif_get_previous_state();

				edif_cp = edif_c_buf_p;
				edif_bp = ediftext_ptr + EDIF_MORE_ADJ;
				goto edif_find_action;
			}
		break;
		}

	default:
		EDIF_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of ediflex */


/* edif_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int edif_get_next_buffer()
	{
	register char *dest = edif_current_buffer->edif_ch_buf;
	register char *source = ediftext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( edif_c_buf_p > &edif_current_buffer->edif_ch_buf[edif_n_chars + 1] )
		EDIF_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( edif_current_buffer->edif_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( edif_c_buf_p - ediftext_ptr - EDIF_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (edif_c_buf_p - ediftext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( edif_current_buffer->edif_buffer_status == EDIF_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		edif_current_buffer->edif_n_chars = edif_n_chars = 0;

	else
		{
		int num_to_read =
			edif_current_buffer->edif_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef EDIF_USES_REJECT
			EDIF_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			EDIF_BUFFER_STATE b = edif_current_buffer;

			int edif_c_buf_p_offset =
				(int) (edif_c_buf_p - b->edif_ch_buf);

			if ( b->edif_is_our_buffer )
				{
				int new_size = b->edif_buf_size * 2;

				if ( new_size <= 0 )
					b->edif_buf_size += b->edif_buf_size / 8;
				else
					b->edif_buf_size *= 2;

				b->edif_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					edif_flex_realloc( (void *) b->edif_ch_buf,
							 b->edif_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->edif_ch_buf = 0;

			if ( ! b->edif_ch_buf )
				EDIF_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			edif_c_buf_p = &b->edif_ch_buf[edif_c_buf_p_offset];

			num_to_read = edif_current_buffer->edif_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > EDIF_READ_BUF_SIZE )
			num_to_read = EDIF_READ_BUF_SIZE;

		/* Read in more data. */
		EDIF_INPUT( (&edif_current_buffer->edif_ch_buf[number_to_move]),
			edif_n_chars, num_to_read );

		edif_current_buffer->edif_n_chars = edif_n_chars;
		}

	if ( edif_n_chars == 0 )
		{
		if ( number_to_move == EDIF_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			edifrestart( edifin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			edif_current_buffer->edif_buffer_status =
				EDIF_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	edif_n_chars += number_to_move;
	edif_current_buffer->edif_ch_buf[edif_n_chars] = EDIF_END_OF_BUFFER_CHAR;
	edif_current_buffer->edif_ch_buf[edif_n_chars + 1] = EDIF_END_OF_BUFFER_CHAR;

	ediftext_ptr = &edif_current_buffer->edif_ch_buf[0];

	return ret_val;
	}


/* edif_get_previous_state - get the state just before the EOB char was reached */

static edif_state_type edif_get_previous_state()
	{
	register edif_state_type edif_current_state;
	register char *edif_cp;

	edif_current_state = edif_start;

	for ( edif_cp = ediftext_ptr + EDIF_MORE_ADJ; edif_cp < edif_c_buf_p; ++edif_cp )
		{
		register EDIF_CHAR edif_c = (*edif_cp ? edif_ec[EDIF_SC_TO_UI(*edif_cp)] : 1);
		if ( edif_accept[edif_current_state] )
			{
			edif_last_accepting_state = edif_current_state;
			edif_last_accepting_cpos = edif_cp;
			}
		while ( edif_chk[edif_base[edif_current_state] + edif_c] != edif_current_state )
			{
			edif_current_state = (int) edif_def[edif_current_state];
			if ( edif_current_state >= 265 )
				edif_c = edif_meta[(unsigned int) edif_c];
			}
		edif_current_state = edif_nxt[edif_base[edif_current_state] + (unsigned int) edif_c];
		}

	return edif_current_state;
	}


/* edif_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = edif_try_NUL_trans( current_state );
 */

#ifdef EDIF_USE_PROTOS
static edif_state_type edif_try_NUL_trans( edif_state_type edif_current_state )
#else
static edif_state_type edif_try_NUL_trans( edif_current_state )
edif_state_type edif_current_state;
#endif
	{
	register int edif_is_jam;
	register char *edif_cp = edif_c_buf_p;

	register EDIF_CHAR edif_c = 1;
	if ( edif_accept[edif_current_state] )
		{
		edif_last_accepting_state = edif_current_state;
		edif_last_accepting_cpos = edif_cp;
		}
	while ( edif_chk[edif_base[edif_current_state] + edif_c] != edif_current_state )
		{
		edif_current_state = (int) edif_def[edif_current_state];
		if ( edif_current_state >= 265 )
			edif_c = edif_meta[(unsigned int) edif_c];
		}
	edif_current_state = edif_nxt[edif_base[edif_current_state] + (unsigned int) edif_c];
	edif_is_jam = (edif_current_state == 264);

	return edif_is_jam ? 0 : edif_current_state;
	}


#ifndef EDIF_NO_UNPUT
#ifdef EDIF_USE_PROTOS
static void edifunput( int c, register char *edif_bp )
#else
static void edifunput( c, edif_bp )
int c;
register char *edif_bp;
#endif
	{
	register char *edif_cp = edif_c_buf_p;

	/* undo effects of setting up ediftext */
	*edif_cp = edif_hold_char;

	if ( edif_cp < edif_current_buffer->edif_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = edif_n_chars + 2;
		register char *dest = &edif_current_buffer->edif_ch_buf[
					edif_current_buffer->edif_buf_size + 2];
		register char *source =
				&edif_current_buffer->edif_ch_buf[number_to_move];

		while ( source > edif_current_buffer->edif_ch_buf )
			*--dest = *--source;

		edif_cp += (int) (dest - source);
		edif_bp += (int) (dest - source);
		edif_current_buffer->edif_n_chars =
			edif_n_chars = edif_current_buffer->edif_buf_size;

		if ( edif_cp < edif_current_buffer->edif_ch_buf + 2 )
			EDIF_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--edif_cp = (char) c;


	ediftext_ptr = edif_bp;
	edif_hold_char = *edif_cp;
	edif_c_buf_p = edif_cp;
	}
#endif	/* ifndef EDIF_NO_UNPUT */


#ifndef EDIF_NO_INPUT
#ifdef __cplusplus
static int edifinput()
#else
static int input()
#endif
	{
	int c;

	*edif_c_buf_p = edif_hold_char;

	if ( *edif_c_buf_p == EDIF_END_OF_BUFFER_CHAR )
		{
		/* edif_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( edif_c_buf_p < &edif_current_buffer->edif_ch_buf[edif_n_chars] )
			/* This was really a NUL. */
			*edif_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = edif_c_buf_p - ediftext_ptr;
			++edif_c_buf_p;

			switch ( edif_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because edif_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					edifrestart( edifin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( edifwrap() )
						return EOF;

					if ( ! edif_did_buffer_switch_on_eof )
						EDIF_NEW_FILE;
#ifdef __cplusplus
					return edifinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					edif_c_buf_p = ediftext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) edif_c_buf_p;	/* cast for 8-bit char's */
	*edif_c_buf_p = '\0';	/* preserve ediftext */
	edif_hold_char = *++edif_c_buf_p;


	return c;
	}
#endif /* EDIF_NO_INPUT */

#ifdef EDIF_USE_PROTOS
void edifrestart( FILE *input_file )
#else
void edifrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! edif_current_buffer )
		edif_current_buffer = edif_create_buffer( edifin, EDIF_BUF_SIZE );

	edif_init_buffer( edif_current_buffer, input_file );
	edif_load_buffer_state();
	}


#ifdef EDIF_USE_PROTOS
void edif_switch_to_buffer( EDIF_BUFFER_STATE new_buffer )
#else
void edif_switch_to_buffer( new_buffer )
EDIF_BUFFER_STATE new_buffer;
#endif
	{
	if ( edif_current_buffer == new_buffer )
		return;

	if ( edif_current_buffer )
		{
		/* Flush out information for old buffer. */
		*edif_c_buf_p = edif_hold_char;
		edif_current_buffer->edif_buf_pos = edif_c_buf_p;
		edif_current_buffer->edif_n_chars = edif_n_chars;
		}

	edif_current_buffer = new_buffer;
	edif_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (edifwrap()) processing, but the only time this flag
	 * is looked at is after edifwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	edif_did_buffer_switch_on_eof = 1;
	}


#ifdef EDIF_USE_PROTOS
void edif_load_buffer_state( void )
#else
void edif_load_buffer_state()
#endif
	{
	edif_n_chars = edif_current_buffer->edif_n_chars;
	ediftext_ptr = edif_c_buf_p = edif_current_buffer->edif_buf_pos;
	edifin = edif_current_buffer->edif_input_file;
	edif_hold_char = *edif_c_buf_p;
	}


#ifdef EDIF_USE_PROTOS
EDIF_BUFFER_STATE edif_create_buffer( FILE *file, int size )
#else
EDIF_BUFFER_STATE edif_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	EDIF_BUFFER_STATE b;

	b = (EDIF_BUFFER_STATE) edif_flex_alloc( sizeof( struct edif_buffer_state ) );
	if ( ! b )
		EDIF_FATAL_ERROR( "out of dynamic memory in edif_create_buffer()" );

	b->edif_buf_size = size;

	/* edif_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->edif_ch_buf = (char *) edif_flex_alloc( b->edif_buf_size + 2 );
	if ( ! b->edif_ch_buf )
		EDIF_FATAL_ERROR( "out of dynamic memory in edif_create_buffer()" );

	b->edif_is_our_buffer = 1;

	edif_init_buffer( b, file );

	return b;
	}


#ifdef EDIF_USE_PROTOS
void edif_delete_buffer( EDIF_BUFFER_STATE b )
#else
void edif_delete_buffer( b )
EDIF_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == edif_current_buffer )
		edif_current_buffer = (EDIF_BUFFER_STATE) 0;

	if ( b->edif_is_our_buffer )
		edif_flex_free( (void *) b->edif_ch_buf );

	edif_flex_free( (void *) b );
	}



#ifdef EDIF_USE_PROTOS
void edif_init_buffer( EDIF_BUFFER_STATE b, FILE *file )
#else
void edif_init_buffer( b, file )
EDIF_BUFFER_STATE b;
FILE *file;
#endif


	{
	edif_flush_buffer( b );

	b->edif_input_file = file;
	b->edif_fill_buffer = 1;

#if EDIF_ALWAYS_INTERACTIVE
	b->edif_is_interactive = 1;
#else
#if EDIF_NEVER_INTERACTIVE
	b->edif_is_interactive = 0;
#else
	b->edif_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef EDIF_USE_PROTOS
void edif_flush_buffer( EDIF_BUFFER_STATE b )
#else
void edif_flush_buffer( b )
EDIF_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->edif_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->edif_ch_buf[0] = EDIF_END_OF_BUFFER_CHAR;
	b->edif_ch_buf[1] = EDIF_END_OF_BUFFER_CHAR;

	b->edif_buf_pos = &b->edif_ch_buf[0];

	b->edif_at_bol = 1;
	b->edif_buffer_status = EDIF_BUFFER_NEW;

	if ( b == edif_current_buffer )
		edif_load_buffer_state();
	}


#ifndef EDIF_NO_SCAN_BUFFER
#ifdef EDIF_USE_PROTOS
EDIF_BUFFER_STATE edif_scan_buffer( char *base, edif_size_t size )
#else
EDIF_BUFFER_STATE edif_scan_buffer( base, size )
char *base;
edif_size_t size;
#endif
	{
	EDIF_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != EDIF_END_OF_BUFFER_CHAR ||
	     base[size-1] != EDIF_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (EDIF_BUFFER_STATE) edif_flex_alloc( sizeof( struct edif_buffer_state ) );
	if ( ! b )
		EDIF_FATAL_ERROR( "out of dynamic memory in edif_scan_buffer()" );

	b->edif_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->edif_buf_pos = b->edif_ch_buf = base;
	b->edif_is_our_buffer = 0;
	b->edif_input_file = 0;
	b->edif_n_chars = b->edif_buf_size;
	b->edif_is_interactive = 0;
	b->edif_at_bol = 1;
	b->edif_fill_buffer = 0;
	b->edif_buffer_status = EDIF_BUFFER_NEW;

	edif_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef EDIF_NO_SCAN_STRING
#ifdef EDIF_USE_PROTOS
EDIF_BUFFER_STATE edif_scan_string( edifconst char *edif_str )
#else
EDIF_BUFFER_STATE edif_scan_string( edif_str )
edifconst char *edif_str;
#endif
	{
	int len;
	for ( len = 0; edif_str[len]; ++len )
		;

	return edif_scan_bytes( edif_str, len );
	}
#endif


#ifndef EDIF_NO_SCAN_BYTES
#ifdef EDIF_USE_PROTOS
EDIF_BUFFER_STATE edif_scan_bytes( edifconst char *bytes, int len )
#else
EDIF_BUFFER_STATE edif_scan_bytes( bytes, len )
edifconst char *bytes;
int len;
#endif
	{
	EDIF_BUFFER_STATE b;
	char *buf;
	edif_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) edif_flex_alloc( n );
	if ( ! buf )
		EDIF_FATAL_ERROR( "out of dynamic memory in edif_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = EDIF_END_OF_BUFFER_CHAR;

	b = edif_scan_buffer( buf, n );
	if ( ! b )
		EDIF_FATAL_ERROR( "bad buffer in edif_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->edif_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef EDIF_NO_PUSH_STATE
#ifdef EDIF_USE_PROTOS
static void edif_push_state( int new_state )
#else
static void edif_push_state( new_state )
int new_state;
#endif
	{
	if ( edif_start_stack_ptr >= edif_start_stack_depth )
		{
		edif_size_t new_size;

		edif_start_stack_depth += EDIF_START_STACK_INCR;
		new_size = edif_start_stack_depth * sizeof( int );

		if ( ! edif_start_stack )
			edif_start_stack = (int *) edif_flex_alloc( new_size );

		else
			edif_start_stack = (int *) edif_flex_realloc(
					(void *) edif_start_stack, new_size );

		if ( ! edif_start_stack )
			EDIF_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	edif_start_stack[edif_start_stack_ptr++] = EDIF_START;

	BEGIN(new_state);
	}
#endif


#ifndef EDIF_NO_POP_STATE
static void edif_pop_state()
	{
	if ( --edif_start_stack_ptr < 0 )
		EDIF_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(edif_start_stack[edif_start_stack_ptr]);
	}
#endif


#ifndef EDIF_NO_TOP_STATE
static int edif_top_state()
	{
	return edif_start_stack[edif_start_stack_ptr - 1];
	}
#endif

#ifndef EDIF_EXIT_FAILURE
#define EDIF_EXIT_FAILURE 2
#endif

#ifdef EDIF_USE_PROTOS
static void edif_fatal_error( edifconst char msg[] )
#else
static void edif_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( EDIF_EXIT_FAILURE );
	}



/* Redefine edifless() so it works in section 3 code. */

#undef edifless
#define edifless(n) \
	do \
		{ \
		/* Undo effects of setting up ediftext. */ \
		ediftext[edifleng] = edif_hold_char; \
		edif_c_buf_p = ediftext + n; \
		edif_hold_char = *edif_c_buf_p; \
		*edif_c_buf_p = '\0'; \
		edifleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef ediftext_ptr
#ifdef EDIF_USE_PROTOS
static void edif_flex_strncpy( char *s1, edifconst char *s2, int n )
#else
static void edif_flex_strncpy( s1, s2, n )
char *s1;
edifconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef EDIF_NEED_STRLEN
#ifdef EDIF_USE_PROTOS
static int edif_flex_strlen( edifconst char *s )
#else
static int edif_flex_strlen( s )
edifconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef EDIF_USE_PROTOS
static void *edif_flex_alloc( edif_size_t size )
#else
static void *edif_flex_alloc( size )
edif_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef EDIF_USE_PROTOS
static void *edif_flex_realloc( void *ptr, edif_size_t size )
#else
static void *edif_flex_realloc( ptr, size )
void *ptr;
edif_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef EDIF_USE_PROTOS
static void edif_flex_free( void *ptr )
#else
static void edif_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if EDIF_MAIN
int main()
	{
	ediflex();
	return 0;
	}
#endif
#line 74 "../../../src/mbkedif/src/parser_l.l"


void edifJumpOver (nParenthesis)
int nParenthesis;
{
  char cRead;
  while(nParenthesis!=0) {
    if((cRead=input())==0) break;   
    switch(cRead) {
        case '\n': ediflineno ++;     break;
        case '(' : nParenthesis ++; break;
        case ')' : nParenthesis --; break;
    }
  }
	if (nParenthesis > 0) puts("Not enought closing parentesis");
	else if(nParenthesis < 0) puts("Too many closing parentesis");
}
