/*
    Copyright (C) 2006-2009 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdlib.h>
#include <alsa/asoundlib.h>
#include <clthreads.h>
#include <clalsadrv.h>
#include <jack/jack.h>
#include "shdata.h"


#define DECAY 30.0f   // Meter decay in dB/s


class Audiothr : public P_thread
{
public:

    enum { N_IP = 8, N_OP = 8 };

    Audiothr (Shdata *shdata);
    virtual ~Audiothr (void);

private:

    virtual void thr_main (void);

    void  init_alsa (void);
    void  close_alsa (void);
    void  init_jack (void);
    void  close_jack (void);
    void  jack_shutdown (void);
    int   jack_callback (jack_nframes_t nframes);
    void  init (void);
    void  process (void);

    Shdata         *_shdata;

    volatile bool   _run_alsa;
    Alsa_driver    *_alsa_handle;
    Esync           _alsa_sync;

    volatile bool   _run_jack;
    jack_client_t  *_jack_handle;
    jack_port_t    *_jack_ip [N_IP];
    jack_port_t    *_jack_op [N_OP];

    float          *_ip [N_IP];
    float          *_op [N_OP];
    U32             _fsamp;
    S32             _nplay;
    S32             _ncapt;
    U32             _fsize;
    U32             _scnt;
    float           _decay;
  
    static void jack_static_shutdown (void *arg);
    static int  jack_static_callback (jack_nframes_t nframes, void *arg);
};


