<!--
	Alcove stylesheet for DocBook articles.

	Please refer to this stylesheet using the following public ID:

		-//Alcove//DOCUMENT DocBook Article Print Stylesheet//EN
-->

<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY parent.dsl PUBLIC "-//Alcove//DOCUMENT DocBook Extended Print Stylesheet//EN" CDATA dsssl>
]>
<style-sheet>
  <style-specification id="print" use="parent">
    <style-specification-body> 

(define ($object-titles-after$)
  '("figure"))

;;
;; Generic layout
;;

(define %paper-type% "A4")
(define %left-margin% 2cm)		; 6pi
(define %right-margin% 2cm)		; 6pi
(define %top-margin% 2.5cm)		; 6pi
(define %bottom-margin% 2.5cm)		; 8pi
(define %header-margin% 1cm)		; 4pi

;; two columns
(define %page-n-columns% 2)

(define %body-start-indent% 0pt)

(define %body-font-family% "cmr")
(define %title-font-family% "cmr")
(define %mono-font-family% "cmtt")
(define %line-spacing-factor% 1)

(define %section-autolabel% #t)
(define %default-quadding% 'justify)

;; only arabic page numbers, even on ToC pages
(define ($page-number-format$ #!optional (gi (gi)))
	"1")

;;
;; titlepage
;;

(define %generate-article-titlepage% #t)

;; what we want on titlepage
(define (article-titlepage-recto-elements)
  (list
   (normalize "title")
   (normalize "corpauthor")
   (normalize "authorgroup")
   (normalize "author")
   (normalize "pubdate")
   (normalize "abstract")))

(define (article-titlepage-verso-elements)
  '())

;; display URL on line following CorpAuthor's name
(element (corpauthor ulink)
  (make sequence
    (process-children)
    (make paragraph
      font-size: (HSIZE 2)
      font-weight: 'medium
      (literal (attribute-string (normalize "url"))))))

(mode article-titlepage-recto-mode
  ;; FIXME: move most of this in "changes below" after parametrisation

  ;; suppress the silly "affiliation" empty paragraph for CorpAuthor
  (element corpauthor
    (make paragraph
      use: article-titlepage-recto-style
      font-size: (HSIZE 4)
;      line-spacing: (* (HSIZE 3) %line-spacing-factor%)
      space-after: 0pt
      space-before: (* (HSIZE 1) %head-before-factor%)
      quadding: %article-title-quadding%
      keep-with-next?: #t
      (process-children)))

  (element author
    (let* ((author-name  (author-string))
	   (author-affil (select-elements (children (current-node)) 
					  (normalize "affiliation")))
	   (author-email (select-elements (descendants author-affil)
					  (normalize "email")))
	   (author-org (select-elements (descendants author-affil)
					  (normalize "orgname")))
	   )
      (make sequence
	use: set-titlepage-recto-style
	quadding: %division-title-quadding%
;;;	line-spacing: (* (HSIZE 3) %line-spacing-factor%)
;;;	space-before: (* (HSIZE 2) %head-before-factor%)
	
	(if (first-sibling? (current-node))
	    (make paragraph
	      font-size: %bf-size%
	      space-after: (* (HSIZE 1) .3 %line-spacing-factor%)
	      keep-with-next?: #t
	      (literal (gentext-alcove-authors)))
	    (empty-sosofo))

	(make paragraph
	  font-size: %bf-size%
	  keep-with-next?: #t

	  (make sequence
	    (literal author-name)
	    (if (node-list-empty? author-org)
		(empty-sosofo)
		(make sequence
		  (literal ", ")
		  (literal (data author-org))))
	    (if (node-list-empty? author-email)
		(empty-sosofo)
		(make sequence
		  (literal " <")
		  (literal (data author-email))
		  (literal ">")))
	    )))))

  (element abstract
;;; BEGIN addition
    (make sequence
      (make paragraph
	use: set-titlepage-recto-style
	font-size: %bf-size%
	quadding: %division-title-quadding%
	space-before: (* (HSIZE 2) %head-before-factor%)
	space-after: 0pt
	(literal (gentext-element-name (current-node)))
	(literal (gentext-label-title-sep (current-node))))
;;; END addition
      (make display-group
	use: article-titlepage-verso-style ;; EVEN THOUGH IT'S RECTO!
	quadding: 'start
;;; BEGIN change
	start-indent: (+ (inherited-start-indent) (/ %body-width% 25))
	end-indent: (+ (inherited-end-indent) (/ %body-width% 25))
	(process-children))))
;;; END change


  )

(define %admon-graphics% #t)


;;
;; Misc parameters
;;

;(define %verbatim-size-factor% 1.1)
(define bop-footnotes #t)
(define %footnote-ulinks% #t)
(define %hyphenation% #t)

    </style-specification-body>
  </style-specification>

  <external-specification id="parent" document="parent.dsl">
</style-sheet>
