//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "shortcuts.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString Shortcuts::filename()
{
  return QString("%1/shortcuts.html").arg(TEMP_DIR);
}
//==============================================
void Shortcuts::generateHTML(QTextStream::Encoding type, QString charSet)
{
  QString Control = "Ctrl";
  QString ControlPlus = "Ctrl+";
#if defined(Q_OS_MACX)
  Control = (QString(QChar(0x2318)));
  ControlPlus = Control;
#endif

  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    //-----
    stream << "<table cellpadding='4'><tr>\n";
    stream << "  <td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "  <td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Keyboard Shortcuts") << "</font></td>\n";
    stream << "</tr></table>\n";

    stream << "<font face='Arial, sans-serif'>\n";
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'>\n";
    stream << "<tr><td width='50%' bgcolor='lightgray'><font size='+1'><b>" << HelpWindow::tr("Action") << "</font></b></td>\n";
    stream << "<td width='50%' bgcolor='lightgray'><font size='+1'><b>" << HelpWindow::tr("Shortcut") << "</font></b></td></tr>\n";
    stream << "<!-- -------------------------------------------------- -->\n";
    stream << "<tr><td colspan='2'><font size='+1'><b><u>" << HelpWindow::tr("Opening &amp; Saving") << "</u></font></b></td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("New album") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_N)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Open album") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_O)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Open recent album") << "</td>\n";
    stream << "    <td>" << ControlPlus << "[1-9]" << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Save album") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_S)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Save album as") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::SHIFT + Qt::CTRL + Qt::Key_S)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Quit") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_Q)) << "</td></tr>\n";
    stream << "<!-- -------------------------------------------------- -->\n";
    stream << "<tr><td colspan='2'><hr></td></tr>\n";
    stream << "<tr><td colspan='2'><font size='+1'><b><u>" << HelpWindow::tr("Organizing") << "</u></font></b></td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Move to the first photo in the collection") << "</td>\n";
    stream << "    <td> Home </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Move to the last photo in the collection") << "</td>\n";
    stream << "    <td> End </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Select all photos") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_A)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Deselect all photos") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::SHIFT + Qt::CTRL + Qt::Key_A)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Rotate selected photos right") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_R)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Rotate selected photos left") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_L)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Delete selected photos") << "</td>\n";
    stream << "    <td> Del </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Modify selected photo description") << "</td>\n";
    stream << "    <td> Enter </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Finish modifying selected photo description") << "</td>\n";
    stream << "    <td> Esc </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Edit first of selected photos") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_E)) << "</td></tr>\n";
    stream << "<!-- -------------------------------------------------- -->\n";
    stream << "<tr><td colspan='2'><hr></td></tr>\n";
    stream << "<tr><td colspan='2'><font size='+1'><b><u>" << HelpWindow::tr("Editing") << "</u></font></b></td></tr>\n";

    stream << "<tr><td>" << HelpWindow::tr("Go to previous photo") << "</td>\n";
    stream << "    <td> PgUp </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Go to next photo") << "</td>\n";
    stream << "    <td> PgDown </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Go to first photo in the collection") << "</td>\n";
    stream << "    <td> Home </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Go to last photo in the collection") << "</td>\n";
    stream << "    <td> End </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Return to organizing") << "</td>\n";
    stream << "    <td> Esc </td></tr>\n";

    stream << "<!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "<tr><td colspan='2'>&nbsp;</td></tr>\n";
    stream << "<!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "<tr><td>" << HelpWindow::tr("Rotate photo right") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_R)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Rotate photo left") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_L)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Flip photo horizontally") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_F)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Flip photo vertically") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::ALT + Qt::CTRL + Qt::Key_F)) << "</td></tr>\n";
    stream << "<!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "<tr><td colspan='2'>&nbsp;</td></tr>\n";
    stream << "<!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "<tr><td>" << HelpWindow::tr("Select all") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_A)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Deselect all") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::SHIFT + Qt::CTRL + Qt::Key_A)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Nudge selection left") << "</td>\n";
    stream << "    <td>&larr;</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Nudge selection right") << "</td>\n";
    stream << "    <td>&rarr;</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Nudge selection up") << "</td>\n";
    stream << "    <td>&uarr;</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Nudge selection down") << "</td>\n";
    stream << "    <td>&darr;</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Expand selection") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::Key_Plus,Qt::Key_Equal)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Shrink selection") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::Key_Minus,Qt::Key_Underscore)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Resize selection") << "</td>\n";
    stream << "    <td>" << HelpWindow::tr("Press and hold Shift, then Click and Drag Left / Right") << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Rotate selection") << "</td>\n";
    stream << "    <td>" << (QString(HelpWindow::tr("Press and hold %1, then Click selection"))
                                     .arg( Control )) << "</td></tr>\n";
    stream << "<!-- -------------------------------------------------- -->\n";
    stream << "<tr><td colspan='2'><hr></td></tr>\n";
    stream << "<tr><td colspan='2'><font size='+1'><b><u>" << HelpWindow::tr("Levels and Grain Editors") << "</u></font></b></td></tr>\n";

    stream << "<tr><td>" << HelpWindow::tr("Show alternative") << "</td>\n";
    stream << "    <td>" << QString(HelpWindow::tr("Hold %1")).arg( Control ) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Select entire luminosity/color range") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_A)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Apply") << "</td>\n";
    stream << "    <td> Enter </td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Cancel") << "</td>\n";
    stream << "    <td> Esc </td></tr>\n";

    stream << "<!-- -------------------------------------------------- -->\n";
    stream << "<tr><td colspan='2'><hr></td></tr>\n";
    stream << "<tr><td colspan='2'><font size='+1'><b><u>" << HelpWindow::tr("Miscellaneous") << "</u></font></b></td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("View album statistics") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_I)) << "</td></tr>\n";
    stream << "<tr><td>" << HelpWindow::tr("Album Shaper help") << "</td>\n";
    stream << "    <td>" << ((QString)QKeySequence(Qt::CTRL + Qt::Key_Question)) << "</td></tr>\n";
    stream << "<!-- -------------------------------------------------- -->\n";
    stream << "</table>\n";
    
    stream << "</td></tr>\n";
    stream << "</table></font>\n";
    
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
