#ifdef WIN32
#include "afflib.h"
#include <stdlib.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <io.h>

#include "unix4win32.h"


/* Provide missing functions */

void	warn(const char *fmt, ...)
{
    va_list args;
    va_start(args,fmt);
    vfprintf(stderr,fmt, args);
    fprintf(stderr,": %s",strerror(errno));
}

void	err(int code, const char *fmt, ...)
{
    va_list args;
    va_start(args,fmt);
    vfprintf(stderr,fmt, args);
    fprintf(stderr,": %s",strerror(errno));
    exit(code);
}

void	errx(int code, const char *fmt, ...)
{
    va_list args;
    va_start(args,fmt);
    vfprintf(stderr,fmt, args);
    exit(code);
}

#endif


