#ifndef AIMAGE_H
#define AIMAGE_H

#include <time.h>
#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>

#include <unistd.h>
#include <stdlib.h>
#include <err.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <getopt.h>
#include <term.h>
#include <curses.h>
#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>

#include "timer.h"

#define AIMAGE_CONFIG "AIMAGE_CONFIG"
#define AIMAGE_CONFIG_FILENAME "aimage.cfg"


/* Commands in aimage_os.cpp to handle device specific stuff */
void make_ata_attach_commands(char *cmd_attach,char *cmd_detach,
			      char *dev0,char *dev1,int atadev);
int  scsi_attach(char *fname,int fname_len,class imager *im); // returns 0 if successful & sets fname

/* Global variables for options */
extern char *opt_title;
extern int opt_blink;
extern int opt_debug;

extern timer total_time;

extern int opt_compress;
extern int opt_preview;
extern FILE *opt_logAFF;
extern int opt_pagesize;
extern int opt_compression_level;
extern int opt_compression_type;
extern int opt_auto_compress;
extern int opt_error_count;
extern int opt_retry_count;
extern int opt_quiet;			// 1 if no curses gui
extern int opt_batch;			// output status in batch form
extern int opt_silent;
extern int opt_skip;
extern int opt_use_timers;
extern int opt_skip_sectors;
extern int opt_reverse;
extern int opt_beeps;
extern int opt_readsectors;
extern int opt_hexbuf;
extern int opt_use_timers;
extern int opt_maxsize;
extern char *command_line;
extern int opt_no_dmesg;
extern int opt_no_ifconfig;

/* Current imager */
extern imager **imagers;
extern int num_imagers;
extern int current_imager;

void segwrite_callback(struct affcallback_info *acbi);
void process_config_questions(AFFILE *af,class imager *);
void sig_intr(int arg);
void sig_cont(int arg);
void bold(const char *str);

#define FD_IDENT 65536
#endif

