require "aruba/cucumber"

NOARCH_TRAITS = <<EOF
version: "1.0.0"

project_traits:
  project_name: "features"
  include_path:
  initial_header: "empty_pinit.h"
  coding_style:
    indent_style: "K&R"
    tab_width: 8
    indent_width: 4
  file_encoding:

compiler_traits:
  initial_header: "empty_cinit.h"
  standard_type:
    char_size: 8
    char_alignment: 8
    short_size: 16
    short_alignment: 16
    int_size: 32
    int_alignment: 32
    long_size: 32
    long_alignment: 32
    long_long_size: 64
    long_long_alignment: 64
    float_size: 32
    float_alignment: 32
    double_size: 64
    double_alignment: 64
    long_double_size: 96
    long_double_alignment: 96
    code_ptr_size: 32
    code_ptr_alignment: 32
    data_ptr_size: 32
    data_ptr_alignment: 32
    char_as_unsigned_char: true
  include_path:
  arithmetic:
    logical_right_shift: true
  extension_substitution:
  arbitrary_substitution:
    "typeof": "__typeof__"
    "__typeof": "__typeof__"
    "alignof": "__alignof__"
    "__alignof": "__alignof__"
  identifier_max: 128

linker_traits:
  identifier_max: 128
  identifier_ignore_case: false

message_traits:
  language: "ja_JP"
  change_list:
EOF
