// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>

#include <QtGui/QGridLayout>
#include <QtGui/QToolTip>
#include <QtGui/QLabel>
#include <QtCore/QEvent>
#include <KIconEffect>

#include <klocale.h>

#include <adept/packagedata.h>
#include <adept/util.h>

#ifndef ADEPT_STATEFILTER_H
#define ADEPT_STATEFILTER_H

namespace adept {

struct StateFilter
{
    enum Mask { Installed = 1 << 0,
                NotInstalled = 1 << 1,
                Upgradable = 1 << 2,
                Install = 1 << 3,
                Remove = 1 << 4,
                Keep = 1 << 5,
                Upgrade = 1 << 6 };
    static const int fullMask = 0x7f;

    StateFilter() : d( 0 ), m_mask( fullMask ) {}
    StateFilter( PackageData &_d, int mask ) : d( &_d ), m_mask( mask ) {}

    template< typename T >
    bool operator()( const T &t ) const {
        PackageState s = d->pkgs.get< package::State >( t.token() );
        bool state = false;
        bool action = false;

        if ( (m_mask & Installed) && ( s.installed() && !s.upgradable() ) )
            state = true;
        if ( (m_mask & NotInstalled) && !s.installed() )
            state = true;
        if ( (m_mask & Upgradable) && s.upgradable() )
            state = true;

        if ( (m_mask & Keep) && s.keep() )
            action = true;
        if ( (m_mask & Install) && s.newInstall() )
            action = true;
        if ( (m_mask & Remove) && s.remove() )
            action = true;
        if ( (m_mask & Upgrade) && s.upgrade() )
            action = true;

        return state && action;
    }

protected:
    PackageData *d;
    unsigned m_mask;
};

class StateFilterWidget : public QWidget
{
    Q_OBJECT
protected:
    QMap< QLabel *, bool > m_checked;
    QMap< QLabel *, QPixmap > m_icons;
    QLabel *m_notInstalled, *m_installed, *m_upgradable;
    QLabel *m_install, *m_remove, *m_upgrade, *m_keep;
    QLabel *m_label;
public:
    StateFilterWidget( QWidget *parent );
    void toggle( QLabel *l );
    void setChecked( QLabel *l, bool e );
    bool eventFilter( QObject *o, QEvent *e );

    int stateMask();
Q_SIGNALS:
    void changed();
};

}

#endif
