/* -*- c++ -*- */
//=============================================================================
/**
 *  @file    be_visitor_member_type_decl.h
 *
 *  $Id: be_visitor_member_type_decl.h 92289 2010-10-20 19:53:11Z parsons $
 *
 *  Encapsulation of rules for declaring C++ class members
 *
 *
 *  @author Jeff Parsons
 */
//=============================================================================

#ifndef BE_VISITOR_MEMBER_TYPE_DECL_H
#define BE_VISITOR_MEMBER_TYPE_DECL_H

#include "be_visitor_decl.h"

class TAO_OutStream;

/**
 * @class be_visitor_member_type_decl
 *
 * @brief be_visitor_member_type_decl
 *
 * Contains overloaded methods that generate declarations of
 * CORBA typenames for C++ class members.
 */
class be_visitor_member_type_decl : public be_visitor_decl
{
public:
  be_visitor_member_type_decl (be_visitor_context *ctx);
  virtual ~be_visitor_member_type_decl (void);

  virtual int visit_array (be_array *);
  virtual int visit_component (be_component *);
  virtual int visit_enum (be_enum *);
  virtual int visit_eventtype (be_eventtype *);
  virtual int visit_home (be_home *);
  virtual int visit_interface (be_interface *);
  virtual int visit_predefined_type (be_predefined_type *);
  virtual int visit_sequence (be_sequence *);
  virtual int visit_string (be_string *);
  virtual int visit_structure (be_structure *);
  virtual int visit_typedef (be_typedef *);
  virtual int visit_union (be_union *);
  virtual int visit_valuebox (be_valuebox *);
  virtual int visit_valuetype (be_valuetype *);
};

#endif /* BE_VISITOR_MEMBER_TYPE_DECL_H */

