
/* -*- c++ -*- */
//=============================================================================
/**
 *  @file    be_mirror_port.h
 *
 *  $Id: be_mirror_port.h 91742 2010-09-13 18:23:17Z johnnyw $
 *
 *  Extension of class AST_Mirror_Port for C++ code generation.
 *
 *
 *  @author Jeff Parsons
 */
//=============================================================================


#ifndef BE_MIRROR_PORT_H
#define BE_MIRROR_PORT_H

#include "ast_mirror_port.h"

#include "be_extended_port.h"

class be_visitor;

class be_mirror_port : public virtual AST_Mirror_Port,
                       public virtual be_extended_port
{
  //
  // = TITLE
  //   be_mirror_port
  //
  // = DESCRIPTION
  //   Extension of class AST_Mirror_Port for C++ code generation.
  //
public:
  be_mirror_port (
    UTL_ScopedName *n,
    AST_PortType *porttype_ref);

  virtual ~be_mirror_port (void);

  virtual void destroy (void);

  virtual int accept (be_visitor *visitor);

  DEF_NARROW_FROM_DECL (be_mirror_port);
};

#endif // BE_MIRROR_PORT_H
