
//=============================================================================
/**
 *  @file    interface_ex_idl.cpp
 *
 *  $Id: interface_ex_idl.cpp 88829 2010-02-04 09:21:38Z johnnyw $
 *
 *  Visitor generating code for Interfaces in the
 *  CIAO executor IDL file.
 *
 *
 *  @author Jeff Parsons <j.parsons@vanderbilt.edu>
 */
//=============================================================================


// ************************************************************
// Interface visitor for CIAO executor IDL.
// ************************************************************

be_visitor_interface_ex_idl::be_visitor_interface_ex_idl (
  be_visitor_context *ctx)
  : be_visitor_interface (ctx)
{
}

be_visitor_interface_ex_idl::~be_visitor_interface_ex_idl (void)
{
}

int
be_visitor_interface_ex_idl::visit_interface (be_interface *node)
{
  // In other words, we proceed only if -Glem is present
  // (without which this visitor wouldn't have been created) and
  // -Glfa is not. Use of -Glfa implies that the local CCM_*
  // interface will be generated by traversing a component's
  // facets, whether in the main IDL file or not.
  if (be_global->gen_lem_force_all ())
    {
      return 0;
    }

  // Skip implied IDL nodes.
  if (node->original_interface () != 0)
    {
      return 0;
    }

  if (node->imported () || node->is_abstract ())
    {
      return 0;
    }

  node->gen_facet_idl (*this->ctx_->stream ());

  return 0;
}


