//
// Process_Factory.h,v 1.8 2005/07/04 08:48:58 jwillemsen Exp
//

#ifndef CLIENT_LEAKS_PROCESS_FACTORY_H
#define CLIENT_LEAKS_PROCESS_FACTORY_H
#include /**/ "ace/pre.h"

#include "TestS.h"

/// Implement the Test::Process_Factory interface
class Process_Factory
  : public virtual POA_Test::Process_Factory
{
public:
  /// Constructor
  Process_Factory (CORBA::ORB_ptr orb);

  /// Return 1 if the shutdown message has been received already
  int shutdown_received (void);

  // = The skeleton methods
  virtual Test::Process_ptr create_new_process (ACE_ENV_SINGLE_ARG_DECL)
    ACE_THROW_SPEC ((CORBA::SystemException,Test::Spawn_Failed));

  virtual void noop (ACE_ENV_SINGLE_ARG_DECL)
    ACE_THROW_SPEC ((CORBA::SystemException));

  virtual void shutdown (ACE_ENV_SINGLE_ARG_DECL)
    ACE_THROW_SPEC ((CORBA::SystemException));

private:
  /// Use an ORB reference to conver strings to objects and shutdown
  /// the application.
  CORBA::ORB_var orb_;

  /// Set to 1 when the test has finished
  int shutdown_received_;
};

#include /**/ "ace/post.h"
#endif /* CLIENT_LEAKS_PROCESS_FACTORY_H */
