// This may look like C, but it's really -*- C++ -*-

//=============================================================================
/**
 *  @file    ImR_Client_Adapter.h
 *
 *  ImR_Client_Adapter.h,v 1.2 2005/02/18 09:07:11 jwillemsen Exp
 *
 *  @author  Johnny Willemsen  <jwillemsen@remedy.nl>
 */
//=============================================================================


#ifndef TAO_IMR_CLIENT_ADAPTER_H
#define TAO_IMR_CLIENT_ADAPTER_H

#include /**/ "ace/pre.h"

#include "portableserver_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/Service_Object.h"
#include "ace/CORBA_macros.h"
#include "tao/orbconf.h"
#include "tao/Environment.h"

class TAO_Root_POA;

namespace TAO
{
  namespace Portable_Server
  {
    /**
     * @class ImR_Client_Adapter
     *
     * @brief IFR_Client_Adapter.
     *
     * Class that adapts various functions in the PortableServer library
     * which use the Implementation Repository. This is a base class for
     * the actual implementation in the TAO_IMR_Client library.
     */
    class TAO_PortableServer_Export ImR_Client_Adapter :
      public ACE_Service_Object
    {
    public:
      virtual ~ImR_Client_Adapter (void);

      /// ImplRepo helper method, notify the ImplRepo on startup
      virtual void imr_notify_startup (TAO_Root_POA* poa ACE_ENV_ARG_DECL) = 0;

      /// ImplRepo helper method, notify the ImplRepo on shutdown
      virtual void imr_notify_shutdown (TAO_Root_POA* poa ACE_ENV_ARG_DECL) = 0;
    };
  }
}

#include /**/ "ace/post.h"
#endif /* TAO_IMR_CLIENT_ADAPTER_H */
