#include "ORBInitializer.h"

#include "orbsvcs/LoadBalancing/LB_ServerRequestInterceptor.h"

#include "tao/ORB_Constants.h"


ACE_RCSID (CPU_Loaded,
           ORBInitializer,
           "ORBInitializer.cpp,v 1.3 2005/06/14 08:54:59 jwillemsen Exp")


ORBInitializer::ORBInitializer (void)
  : load_alert_ ()
{
}

void
ORBInitializer::pre_init (
    PortableInterceptor::ORBInitInfo_ptr
    ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
}

void
ORBInitializer::post_init (
    PortableInterceptor::ORBInitInfo_ptr info
    ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  PortableInterceptor::ServerRequestInterceptor_ptr reject_interceptor;
  ACE_NEW_THROW_EX (reject_interceptor,
                    TAO_LB_ServerRequestInterceptor (this->load_alert_),
                    CORBA::NO_MEMORY (
                      CORBA::SystemException::_tao_minor_code (
                        TAO::VMCID,
                        ENOMEM),
                      CORBA::COMPLETED_NO));
  ACE_CHECK;

  PortableInterceptor::ServerRequestInterceptor_var safe_reject_interceptor =
    reject_interceptor;

  info->add_server_request_interceptor (safe_reject_interceptor.in ()
                                        ACE_ENV_ARG_PARAMETER);
  ACE_CHECK;
}


TAO_LB_LoadAlert &
ORBInitializer::load_alert (void)
{
  return this->load_alert_;
}
