// Gateway_i.h,v 1.6 2005/07/04 08:55:12 jwillemsen Exp

//=============================================================================
/**
 * @file Gateway_i.h
 *
 * Gateway_i.h,v 1.6 2005/07/04 08:55:12 jwillemsen Exp
 *
 * Implementation header used for forwarding the requests from the
 * gateway to the server and reply to the client
 *
 * @author Carlos O'Ryan <coryan@uci.edu>
 * @author Priyanka Gontla <gontla_p@ociweb.com>
 */
//=============================================================================

#ifndef GATEWAY_I_H
#define GATEWAY_I_H

#include "tao/DynamicInterface/DII_CORBA_methods.h"
#include "tao/PortableServer/PortableServer.h"
#include "tao/DynamicInterface/Dynamic_Implementation.h"
#include "tao/IFR_Client/IFR_Client_Adapter_Impl.h"
#include "tao/PI_Server/PI_Server.h"

class Gateway_i
  : public virtual PortableServer::DynamicImplementation
{
public:
  Gateway_i (CORBA::ORB_ptr orb,
             PortableServer::Current_ptr poa_current);

  virtual void invoke (CORBA::ServerRequest_ptr request
                       ACE_ENV_ARG_DECL);

  virtual CORBA::RepositoryId _primary_interface (
      const PortableServer::ObjectId &oid,
      PortableServer::POA_ptr poa
      ACE_ENV_ARG_DECL);

 private:

  CORBA::ORB_ptr orb_;

  PortableServer::Current_ptr poa_current_;
};

#endif /* GATEWAY_I_H */
