//TestServer.h,v 1.2 2005/05/24 14:20:09 michel_j Exp
#include "Messenger_i.h"

#include "ace/Auto_Ptr.h"

#include "tao/IORTable/IORTable.h"

#include <string>
#include <vector>

class TestServer
{
public:
  TestServer(CORBA::ORB_ptr, int argc, char* argv[]);

  ~TestServer();

  void run();

private:
  int parseCommands(int argc, char* argv[]);
  bool verifyEnvironment() const;
  bool registerWithManager();
  void buildObjects();
  void pause(int milliseconds);

  int   serverID_;
  int   serverInstanceID_;
  bool  useIORTable_;
  bool  writeIORFile_;
  bool  retryQuery_;
  char  pauseType_;
  int   startupPause_;
  int   objActivatePause_;
  int   activatePause_;
  int   runPause_;
  int   numPOAS_;
  int   numObjsPerPOA_;
  int   useItLoseItSecs_;

  std::string baseDir_;
  std::string expectedDir_;
  std::vector<std::pair<std::string, std::string> > expectedEnv_;
  ACE_Auto_Ptr<Messenger_i>  servant_;

  CORBA::ORB_var                  orb_;
  IORTable::Table_var             iorTable_;
  PortableServer::POA_var         root_;
  PortableServer::POAManager_var  mgr_;
};
