// file      : CCF/IDL2/SemanticAction/Impl/Native.cpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : Native.cpp,v 1.2 2004/01/01 00:12:30 boris Exp

#include "CCF/IDL2/SemanticGraph/Native.hpp"
#include "CCF/IDL2/SemanticAction/Impl/Native.hpp"

#include <iostream>

using std::cerr;
using std::endl;

namespace CCF
{
  namespace IDL2
  {
    namespace SemanticAction
    {
      namespace Impl
      {
        using namespace SemanticGraph;

        Native::
        Native (Context& c)
            : Base (c)
        {
        }

        void Native::
        name (SimpleIdentifierPtr const& id)
        {
          if (ctx.trace ()) cerr << "native " << id << endl;

          SimpleName name (id->lexeme ());

          SemanticGraph::Native& n (
            ctx.tu ().new_node<SemanticGraph::Native> ());

          ctx.tu ().new_edge<Defines> (ctx.scope (), n, name);
        }

        void Native::
        end ()
        {
          if (ctx.trace ()) cerr << "end" << endl;
        }
      }
    }
  }
}
