#ifndef XMMS__H
#define XMMS__H

#include <pthread.h>

#include XMMS_INCLUDE

typedef enum
{
  SKIN_MAIN, SKIN_CBUTTONS, SKIN_TITLEBAR, SKIN_SHUFREP, SKIN_TEXT,
    SKIN_VOLUME,
  SKIN_BALANCE, SKIN_MONOSTEREO, SKIN_PLAYPAUSE, SKIN_NUMBERS, SKIN_POSBAR,
  SKIN_PLEDIT, SKIN_EQMAIN, SKIN_EQ_EX,
} SkinIndex;

typedef struct _Widget
{
  GdkPixmap *parent;
  GdkGC *gc;
  gint x, y, width, height, visible;
  void (*button_press_cb) (GtkWidget *, GdkEventButton *, gpointer);
  void (*button_release_cb) (GtkWidget *, GdkEventButton *, gpointer);
  void (*motion_cb) (GtkWidget *, GdkEventMotion *, gpointer);
  void (*draw) (struct _Widget *);
  gboolean redraw;
  pthread_mutex_t mutex;
}
Widget;

typedef struct
{
  Widget pb_widget;
  gint pb_nx, pb_ny, pb_px, pb_py;
  gboolean pb_pressed, pb_inside, pb_allow_draw;
  void (*pb_push_cb) (void);
  SkinIndex pb_skin_index1, pb_skin_index2;
}
PButton;

gboolean dock_is_moving (GtkWidget * w);
void dock_move_release (GtkWidget * w);
void dock_get_widget_pos (GtkWidget * w, gint * x, gint * y);
void dock_move_press (GList * window_list, GtkWidget * w,
		      GdkEventButton * event, gboolean move_list);
void dock_move_motion (GtkWidget * w, GdkEventMotion * event);
GList *dock_add_window (GList * window_list, GtkWidget * window);

void skin_draw_pixmap (GdkDrawable * drawable, GdkGC * gc, SkinIndex si,
		       gint xsrc, gint ysrc, gint xdest, gint ydest,
		       gint width, gint height);

int inside_widget (gint x, gint y, void *w);
void widget_list_change_pixmap (GList * wlist, GdkPixmap * pixmap);
void move_widget (void *w, gint x, gint y);
void lock_widget_list (GList * wlist);
void unlock_widget_list (GList * wlist);
void draw_widget_list (GList * wlist, gboolean * redraw, gboolean force);
void handle_press_cb (GList * wlist, GtkWidget * widget,
		      GdkEventButton * event);
void handle_release_cb (GList * wlist, GtkWidget * widget,
			GdkEventButton * event);
void handle_motion_cb (GList * wlist, GtkWidget * widget,
		       GdkEventMotion * event);

PButton *create_pbutton (GList ** wlist, GdkPixmap * parent, GdkGC * gc,
			 gint x, gint y, gint w, gint h, gint nx, gint ny,
			 gint px, gint py, void (*cb) (void), SkinIndex si);

gint ctrlsocket_get_session_id(void);   /* FIXME */

extern Config cfg;
extern GList *dock_window_list;

#endif
