/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * phystrack.h --
 *
 *    track down the utilization of the physical pages
 */

#ifndef PHYSTRACK_H
#define PHYSTRACK_H

#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

struct PhysTracker;

EXTERN struct PhysTracker *PhysTrack_Alloc(void);
EXTERN struct PhysTracker *PhysTrack_Init(void);

EXTERN void PhysTrack_Add(struct PhysTracker *, MPN );
EXTERN void PhysTrack_Remove(struct PhysTracker *, MPN );
EXTERN Bool PhysTrack_Test(const struct PhysTracker *, MPN );
EXTERN MPN  PhysTrack_GetNext(const struct PhysTracker *, MPN );

EXTERN void PhysTrack_Cleanup(struct PhysTracker *);
#endif






