/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#ifndef __VMNETINT_H__
#define __VMNETINT_H__


#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"
#include "driver-config.h"


/*
 * Hide all kernel compatibility stuff in those macros
 */


#ifdef KERNEL_2_4_0
#   define compat_fop_set_owner(_pFop) do { \
   (_pFop)->owner = THIS_MODULE;            \
} while (0)
#   define compat_mod_inc_refcount
#   define compat_mod_dec_refcount
#else
#   define compat_fop_set_owner(_pFop)
#   define compat_mod_inc_refcount do { \
   MOD_INC_USE_COUNT;                   \
} while (0)
#   define compat_mod_dec_refcount do { \
   MOD_DEC_USE_COUNT;                   \
} while (0)
#endif


#ifdef VMW_HAVE_SK_ALLOC_WITH_PROTO
extern struct proto vmnet_proto;
#   define compat_sk_alloc(_pri) sk_alloc(PF_NETLINK, _pri, &vmnet_proto, 1)
#elif defined(KERNEL_2_5_5)
#   define compat_sk_alloc(_pri) sk_alloc(PF_NETLINK, _pri, 1, NULL)
#else
#   define compat_sk_alloc(_pri) sk_alloc(0, _pri, 1)
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
   #define fileTraversalLock(lock) spin_lock(lock)
   #define fileTraversalUnLock(lock) spin_unlock(lock)
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
   #define fileTraversalLock(lock) read_lock(lock)
   #define fileTraversalUnLock(lock) read_unlock(lock)
#else //2.2 kernels
   #define fileTraversalLock(lock) lock_kernel()
   #define fileTraversalUnLock(lock) unlock_kernel()
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
   #define taskLock(lock) task_lock(lock)
   #define taskUnLock(lock) task_unlock(lock)
#else //2.2 kernels
   #define taskLock(lock) lock_kernel()
   #define taskUnLock(lock) unlock_kernel()
#endif

#endif /* __VMNETINT_H__ */
