/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

import java.io.IOException;
import java.net.Socket;

/**
 * 
 * Acts as a surrogate for a container to service a WMS request.  
 *
 * @author brownrigg
 * @version $Id: WMSServiceThread.java 3862 2007-12-10 15:12:41Z rick $
 */
public class WMSServiceThread extends Thread {
    public WMSServiceThread(Socket s) {
        theSocket = s;
    }
    
    public void run() {
        long startTime = 0;
        long endTime;

        try {
            numActiveThreads++;  totalThreads++;
            startTime = System.currentTimeMillis();
            SysLog.inst().info(numActiveThreads + " active threads...");

            WMSHttpServletRequest req = new WMSHttpServletRequest(theSocket);
            WMSHttpServletResponse resp = new WMSHttpServletResponse(theSocket);
            
            WMSServlet servlet = new WMSServlet();
            servlet.init(servletConfig);
            
            if (req.getMethod().equalsIgnoreCase("POST"))
                servlet.doPost(req, resp);
            else
                servlet.doGet(req, resp);
            
            resp.flushBuffer();
        }
        // TODO -- catch WMSServletException!
        catch (IOException ex) {
            SysLog.inst().error("Error in Service Thread: " + ex.toString());
        }
        finally {
            //noinspection EmptyCatchBlock
            try { theSocket.close(); } catch (Exception ex) {}
            numActiveThreads--;
            endTime = System.currentTimeMillis();
            accumTime += (endTime - startTime);

            SysLog.inst().info("Thread duration: " + (double)(endTime-startTime)/1000. +
                "s  -- average is " + ((double)accumTime/1000.) / (double)totalThreads + "s  (" +
                numActiveThreads + ")");
        }
        
    }
    
    @SuppressWarnings({"UnusedDeclaration"})
    private WMSServiceThread() {
    }
    
    private Socket theSocket = null;
    // at present, this never changes, so make only one...
    private static WMSServletConfig servletConfig = new WMSServletConfig();

    // statics for perfomance measures...
    private static int numActiveThreads = 0;
    private static int totalThreads = 0;
    private static long accumTime;
    
    
}
