#!/bin/sh

# this file makes a header file out of a binary file using od2c.sh

BINFILENAME=$1
HEADERFILENAME=$2
ARRAYNAME=$3
CROSS=$4
SHELL=$5

echo Generating $HEADERFILENAME
if test x"$CROSS" = "xtrue"; then
    echo >$HEADERFILENAME "/* Autogenerated file, do not edit */"
    echo >>$HEADERFILENAME ""
    echo >>$HEADERFILENAME "$ARRAYNAME = {"
    od -Ax -t x1 -w8 $BINFILENAME >$HEADERFILENAME.tmp
    $SHELL $TOPSRCDIR/src/od2c.sh <$HEADERFILENAME.tmp >>$HEADERFILENAME
    echo >>$HEADERFILENAME "};"
    rm -f $HEADERFILENAME.tmp
else
    ./bin2c $BINFILENAME $HEADERFILENAME "$ARRAYNAME"
fi
